/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml2;

import eu.dnetlib.data.transform.xml2.Node;
import eu.dnetlib.data.transform.xml2.VtdException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Dom4jUtilityParser {
    public static final String NS_SEPARATOR = ":";

    public static String xpath(String ... p) {
        return Arrays.stream(p).map(s -> String.format("/*[local-name()='%s']", s)).reduce((s1, s2) -> s1 + s2).get();
    }

    public static Document parseXml(String xml) throws DocumentException {
        return new SAXReader().read((Reader)new StringReader(xml));
    }

    public static int countNodes(Document document, String xpath) throws VtdException {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return 0;
        }
        List res = document.selectNodes(xpath);
        return res != null ? res.size() : 0;
    }

    public static Node getNode(Document document, String xpath) throws VtdException {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return new Node();
        }
        return Dom4jUtilityParser.asNode(document.selectSingleNode(xpath));
    }

    public static List<Node> getNodes(Document document, String xpath) throws VtdException {
        ArrayList<Node> results = new ArrayList<Node>();
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return results;
        }
        for (Object o : document.selectNodes(xpath)) {
            results.add(Dom4jUtilityParser.asNode((org.dom4j.Node)o));
        }
        return results;
    }

    private static Node asNode(org.dom4j.Node dNode) {
        Node currentNode = new Node();
        if (dNode == null) {
            return currentNode;
        }
        String name = dNode.getName();
        currentNode.setName(name.contains(NS_SEPARATOR) ? StringUtils.substringAfter((String)name, (String)NS_SEPARATOR) : name);
        currentNode.setTextValue(dNode.getText());
        currentNode.setAttributes(Dom4jUtilityParser.getAttributes(dNode));
        return currentNode;
    }

    private static Map<String, String> getAttributes(org.dom4j.Node dNode) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (dNode instanceof Element) {
            Iterator it = ((Element)dNode).attributeIterator();
            while (it.hasNext()) {
                Attribute a = (Attribute)it.next();
                attributes.put(a.getName(), a.getValue());
            }
        }
        return attributes;
    }

    public static String getFirstValue(Document document, String xpath) throws VtdException {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return null;
        }
        return document.valueOf(xpath);
    }
}

