package eu.dnetlib.data.bulktag;

import com.google.gson.Gson;
import eu.dnetlib.data.bulktag.selectioncriteria.VerbResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * Created by miriam on 02/08/2018.
 */
public class Constraints implements Serializable {
    private static final Log log = LogFactory.getLog(Constraints.class);
    private ConstraintEncapsulator ce;
    //private List<Constraint> ce;


    public Constraints() {
    }

    public ConstraintEncapsulator getCe() {
        return ce;
    }

    public void setCe(ConstraintEncapsulator ce) {
        this.ce = ce;
    }

    public void setSc(String json){

        ce = new Gson().fromJson(json, ConstraintEncapsulator.class);

    }

    void setSelection(VerbResolver resolver) {
        for(Constraint st: ce.getConstraint()){

            try {
                st.setSelection(resolver);
            } catch (NoSuchMethodException e) {
                log.error(e.getMessage());
            } catch (IllegalAccessException e) {
                log.error(e.getMessage());
            } catch (InvocationTargetException e) {
                log.error(e.getMessage());
            } catch (InstantiationException e) {
                log.error(e.getMessage());
            }
        }

    }

//    //Constraint in and
//    public boolean verifyCriteria(Map<String,String> param){
//        for(Constraint ce: ce){
//            if(!ce.verifyCriteria(param.get(ce.getField())))
//                return false;
//        }
//        return true;
//    }

    //Constraint in and
    public boolean verifyCriteria(Map<String,List<String>> param){
        for(Constraint sc: ce.getConstraint()){
            boolean verified = false;
            for(String value : param.get(sc.getField())){
                if (sc.verifyCriteria(value.trim())){
                    verified = true;
                }
            }
            if(!verified)
                return verified;
        }
        return true;
    }
}