/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.bulktag;

import com.google.gson.Gson;
import eu.dnetlib.data.bulktag.Constraint;
import eu.dnetlib.data.bulktag.ConstraintEncapsulator;
import eu.dnetlib.data.bulktag.selectioncriteria.VerbResolver;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Constraints
implements Serializable {
    private static final Log log = LogFactory.getLog(Constraints.class);
    private ConstraintEncapsulator ce;

    public ConstraintEncapsulator getCe() {
        return this.ce;
    }

    public void setCe(ConstraintEncapsulator ce) {
        this.ce = ce;
    }

    public void setSc(String json) {
        this.ce = (ConstraintEncapsulator)new Gson().fromJson(json, ConstraintEncapsulator.class);
    }

    void setSelection(VerbResolver resolver) {
        for (Constraint st : this.ce.getConstraint()) {
            try {
                st.setSelection(resolver);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getMessage());
            }
            catch (InstantiationException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public boolean verifyCriteria(Map<String, List<String>> param) {
        for (Constraint sc : this.ce.getConstraint()) {
            boolean verified = false;
            for (String value : param.get(sc.getField())) {
                if (!sc.verifyCriteria(value.trim())) continue;
                verified = true;
            }
            if (verified) continue;
            return verified;
        }
        return true;
    }
}

