/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.bulktag;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.data.bulktag.Community;
import eu.dnetlib.data.bulktag.CommunityConfiguration;
import eu.dnetlib.data.bulktag.Datasource;
import eu.dnetlib.data.bulktag.ZenodoCommunity;
import eu.dnetlib.data.bulktag.selectioncriteria.InterfaceAdapter;
import eu.dnetlib.data.bulktag.selectioncriteria.Selection;
import eu.dnetlib.data.bulktag.selectioncriteria.VerbResolver;
import eu.dnetlib.data.bulktag.selectioncriteria.VerbResolverFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class CommunityConfigurationFactory {
    private static final Log log = LogFactory.getLog(CommunityConfigurationFactory.class);
    private static VerbResolver resolver = VerbResolverFactory.newInstance();

    public static CommunityConfiguration newInstance(String xml) throws DocumentException {
        log.debug((Object)String.format("parsing community configuration from:\n%s", xml));
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        HashMap communities = Maps.newHashMap();
        for (Object o : doc.selectNodes("//community")) {
            Node node = (Node)o;
            Community community = CommunityConfigurationFactory.parseCommunity(node);
            if (!community.isValid()) continue;
            communities.put(community.getId(), community);
        }
        log.info((Object)String.format("loaded %s community configuration profiles", communities.size()));
        log.debug((Object)String.format("loaded community configuration:\n%s", ((Object)communities).toString()));
        return new CommunityConfiguration(communities);
    }

    public static CommunityConfiguration fromJson(String json) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Selection.class, (Object)new InterfaceAdapter());
        Gson gson = builder.create();
        CommunityConfiguration conf = (CommunityConfiguration)gson.fromJson(json, CommunityConfiguration.class);
        log.info((Object)String.format("loaded %s community configuration profiles", conf.size()));
        conf.init();
        log.info((Object)"created inverse maps");
        return conf;
    }

    private static Community parseCommunity(Node node) {
        Community c = new Community();
        c.setId(node.valueOf("./@id"));
        log.info((Object)String.format("community id: %s", c.getId()));
        c.setSubjects(CommunityConfigurationFactory.parseSubjects(node));
        c.setDatasources(CommunityConfigurationFactory.parseDatasources(node));
        c.setZenodoCommunities(CommunityConfigurationFactory.parseZenodoCommunities(node));
        return c;
    }

    private static List<String> parseSubjects(Node node) {
        ArrayList subjects = Lists.newArrayList();
        List list = node.selectNodes("./subjects/subject");
        for (Node n : list) {
            log.debug((Object)("text of the node " + n.getText()));
            subjects.add(StringUtils.trim((String)n.getText()));
        }
        log.info((Object)("size of the subject list " + subjects.size()));
        return subjects;
    }

    private static List<Datasource> parseDatasources(Node node) {
        List list = node.selectNodes("./datasources/datasource");
        ArrayList<Datasource> datasourceList = new ArrayList<Datasource>();
        for (Node n : list) {
            Datasource d = new Datasource();
            d.setOpenaireId(n.selectSingleNode("./openaireId").getText());
            d.setSelCriteria(n.selectSingleNode("./selcriteria"), resolver);
            datasourceList.add(d);
        }
        log.info((Object)("size of the datasource list " + datasourceList.size()));
        return datasourceList;
    }

    private static List<ZenodoCommunity> parseZenodoCommunities(Node node) {
        String tmp;
        Node oacommunitynode = node.selectSingleNode("./oacommunity");
        String oacommunity = null;
        if (oacommunitynode != null && StringUtils.isNotBlank((CharSequence)(tmp = oacommunitynode.getText()))) {
            oacommunity = tmp;
        }
        List list = node.selectNodes("./zenodocommunities/zenodocommunity");
        ArrayList<ZenodoCommunity> zenodoCommunityList = new ArrayList<ZenodoCommunity>();
        for (Node n : list) {
            ZenodoCommunity zc = new ZenodoCommunity();
            zc.setZenodoCommunityId(n.selectSingleNode("./zenodoid").getText());
            zc.setSelCriteria(n.selectSingleNode("./selcriteria"));
            zenodoCommunityList.add(zc);
        }
        if (oacommunity != null) {
            ZenodoCommunity zc = new ZenodoCommunity();
            zc.setZenodoCommunityId(oacommunity);
            zenodoCommunityList.add(zc);
        }
        log.info((Object)("size of the zenodo community list " + zenodoCommunityList.size()));
        return zenodoCommunityList;
    }
}

