/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Functions;
import com.wcohen.ss.JaroWinkler;
import eu.dnetlib.data.bulktag.Pair;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.pace.model.Person;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class AuthorMerger {
    private static final Double THRESHOLD = 0.95;
    private static final String ORCID = "orcid";
    private static final int MAX_AUTHORS = 200;

    public static List<FieldTypeProtos.Author> merge(Collection<List<FieldTypeProtos.Author>> authors, double threshold) {
        return AuthorMerger.merge(authors, THRESHOLD);
    }

    public static List<FieldTypeProtos.Author> merge(Collection<List<FieldTypeProtos.Author>> authors) {
        ArrayList<FieldTypeProtos.Author> res = new ArrayList<FieldTypeProtos.Author>();
        if (authors.isEmpty()) {
            return res;
        }
        if (authors.size() == 1) {
            return authors.iterator().next();
        }
        TreeMap<Integer, List> byOrcidCount = new TreeMap<Integer, List>(authors.stream().collect(Collectors.groupingBy(AuthorMerger::countOrcid)).entrySet().stream().filter(e -> (Integer)e.getKey() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        if (byOrcidCount == null || byOrcidCount.isEmpty()) {
            return authors.iterator().next();
        }
        Map.Entry<Integer, List> mostOrcid = byOrcidCount.lastEntry();
        if (mostOrcid.getKey() > 0) {
            List pivots = (List)mostOrcid.getValue().iterator().next();
            res.addAll(((List)mostOrcid.getValue().iterator().next()).stream().filter(a -> AuthorMerger.hasOrcid(a)).collect(Collectors.toList()));
            if (pivots.size() == res.size()) {
                return res;
            }
            Collection<FieldTypeProtos.Author> authorList = authors.stream().filter(g -> !g.equals(pivots)).flatMap(Collection::stream).filter(a -> AuthorMerger.hasOrcid(a)).limit(200L).map(a -> {
                String orcid = a.getPidList().stream().filter(p -> p.getKey().equalsIgnoreCase(ORCID)).findFirst().get().getValue();
                return new Pair<String, FieldTypeProtos.Author>(orcid, (FieldTypeProtos.Author)a);
            }).collect(Collectors.toMap(p -> (String)p.getFst(), p -> (FieldTypeProtos.Author)p.getSnd(), (p1, p2) -> p2)).values();
            pivots.stream().filter(a -> !AuthorMerger.hasOrcid(a)).forEach(pivot -> {
                FieldTypeProtos.Author.Builder b = FieldTypeProtos.Author.newBuilder((FieldTypeProtos.Author)pivot);
                authorList.parallelStream().map(a -> new Pair<Double, FieldTypeProtos.Author>(AuthorMerger.sim(a, pivot), (FieldTypeProtos.Author)a)).filter(p -> (Double)p.getFst() >= THRESHOLD).forEach(p -> b.mergeFrom((FieldTypeProtos.Author)p.getSnd()));
                Collection pids = b.getPidList().stream().collect(Collectors.toMap(kv -> kv.getKey(), Functions.identity(), (kv1, kv2) -> kv2)).values();
                b.clearPid();
                b.addAllPid(pids);
                res.add(b.build());
            });
        }
        return res;
    }

    private static int countOrcid(List<FieldTypeProtos.Author> authors) {
        return authors.stream().map(a -> AuthorMerger.hasOrcid(a) ? 1 : 0).mapToInt(Integer::intValue).sum();
    }

    private static boolean hasOrcid(FieldTypeProtos.Author a) {
        return a.getPidList().stream().anyMatch(p -> p.getKey().equalsIgnoreCase(ORCID));
    }

    private static Double sim(FieldTypeProtos.Author a, FieldTypeProtos.Author b) {
        Person pa = AuthorMerger.parse(a);
        Person pb = AuthorMerger.parse(b);
        if (pa.isAccurate() & pb.isAccurate()) {
            return new JaroWinkler().score(AuthorMerger.normalize(pa.getSurnameString()), AuthorMerger.normalize(pb.getSurnameString()));
        }
        return new JaroWinkler().score(AuthorMerger.normalize(pa.getNormalisedFullname()), AuthorMerger.normalize(pb.getNormalisedFullname()));
    }

    private static Person parse(FieldTypeProtos.Author author) {
        if (author.hasSurname()) {
            return new Person(author.getSurname() + ", " + author.getName(), false);
        }
        return new Person(author.getFullname(), false);
    }

    private static String normalize(String s) {
        return AuthorMerger.nfd(s).toLowerCase().replaceAll("(\\W)+", " ").replaceAll("(\\p{InCombiningDiacriticalMarks})+", " ").replaceAll("(\\p{Punct})+", " ").replaceAll("(\\d)+", " ").replaceAll("(\\n)+", " ").trim();
    }

    private static String nfd(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD);
    }
}

