/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OafUtils {
    private static Stream<String> types() {
        return Arrays.stream(TypeProtos.Type.values()).map(Enum::toString);
    }

    public static Set<String> entities() {
        return OafUtils.types().collect(Collectors.toSet());
    }

    public static Function<OafDecoder, String> idDecoder() {
        return input -> input.getEntityId();
    }

    public static Predicate<FieldTypeProtos.StructuredProperty> mainTitleFilter() {
        return sp -> sp.getQualifier() != null && sp.getQualifier().getClassname().equals("main title");
    }

    public static Set<String> getFieldNames(Descriptors.Descriptor d, Integer ... tag) {
        return Sets.newHashSet((Iterable)Iterables.transform(Arrays.asList(tag), i -> {
            Descriptors.FieldDescriptor fd = d.findFieldByNumber(i.intValue());
            if (fd == null) {
                throw new IllegalArgumentException("undefined tag: " + i + " for type: " + d.getFullName());
            }
            return fd.getName();
        }));
    }
}

