/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.bulktag;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import eu.dnetlib.data.bulktag.Constraint;
import eu.dnetlib.data.bulktag.selectioncriteria.VerbResolver;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Constraints
implements Serializable {
    private static final Log log = LogFactory.getLog(Constraints.class);
    private List<Constraint> constraint;

    public List<Constraint> getConstraint() {
        return this.constraint;
    }

    public void setConstraint(List<Constraint> constraint) {
        this.constraint = constraint;
    }

    public void setSc(String json) {
        Type collectionType = new TypeToken<Collection<Constraint>>(){}.getType();
        this.constraint = (List)new Gson().fromJson(json, collectionType);
    }

    void setSelection(VerbResolver resolver) {
        for (Constraint st : this.constraint) {
            try {
                st.setSelection(resolver);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getMessage());
            }
            catch (InstantiationException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public boolean verifyCriteria(Map<String, List<String>> param) {
        for (Constraint sc : this.constraint) {
            boolean verified = false;
            for (String value : param.get(sc.getField())) {
                if (!sc.verifyCriteria(value.trim())) continue;
                verified = true;
            }
            if (verified) continue;
            return verified;
        }
        return true;
    }
}

