/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OpenTrialsXsltFunctions {
    @Deprecated
    public static String getMainIdentifierURL(String jsonProvList) {
        List<JsonProv> provs = OpenTrialsXsltFunctions.getProvs(jsonProvList);
        for (JsonProv prov : provs) {
            if (!StringUtils.isNotBlank((String)prov.getUrl())) continue;
            return prov.getUrl();
        }
        return "";
    }

    public static String getPrimaryRecordUrl(String jsonRecordsList) {
        List<JsonRecord> records = OpenTrialsXsltFunctions.getRecords(jsonRecordsList);
        for (JsonRecord record : records) {
            if (!record.isIs_primary() || !StringUtils.isNotBlank((String)record.getSource_url())) continue;
            return record.getSource_url();
        }
        if (!records.isEmpty() && StringUtils.isNotBlank((String)records.get(0).getSource_url())) {
            return records.get(0).getSource_url();
        }
        return "";
    }

    public static String getPrimaryRecordIdentifier(String jsonRecordsList) {
        List<JsonRecord> records = OpenTrialsXsltFunctions.getRecords(jsonRecordsList);
        for (JsonRecord record : records) {
            if (!record.isIs_primary() || !StringUtils.isNotBlank((String)record.getSource_id())) continue;
            return record.getSource_id();
        }
        if (!records.isEmpty() && StringUtils.isNotBlank((String)records.get(0).getSource_url())) {
            return records.get(0).getSource_id();
        }
        return "";
    }

    public static String getNotPrimaryRecordUrl(String jsonRecordsList) {
        boolean found = false;
        String ret = "";
        List<JsonRecord> records = OpenTrialsXsltFunctions.getRecords(jsonRecordsList);
        for (JsonRecord record : records) {
            if (record.isIs_primary()) {
                found = true;
                continue;
            }
            if (!StringUtils.isNotBlank((String)record.getSource_url())) continue;
            ret = ret + record.getSource_url() + "@@";
        }
        if (!found && ret.length() > 0) {
            ret = ret.substring(ret.indexOf("@@") + 2);
        }
        if (ret.endsWith("@@")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    public static String getPrincipalInvestigators(String jsonPeopleList) {
        List<JsonPeople> people = OpenTrialsXsltFunctions.getPeople(jsonPeopleList);
        String ret = "";
        for (JsonPeople person : people) {
            if (!StringUtils.isNotBlank((String)person.getPerson_role()) || !person.getPerson_role().equals("principal_investigator")) continue;
            ret = ret + OpenTrialsXsltFunctions.conformToGuidelines(person.getPerson_name()) + "@@";
        }
        if (ret.endsWith("@@")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    private static String conformToGuidelines(String person_name) {
        if (person_name.indexOf(",") > -1) {
            person_name = person_name.substring(0, person_name.indexOf(","));
        }
        String[] name = person_name.split(" ");
        person_name = name[name.length - 1] + ",";
        for (int i = 0; i < name.length - 1; ++i) {
            person_name = person_name + " " + name[i];
        }
        return person_name;
    }

    public static String getTrialOrganizations(String jsonOrganizationList) {
        List<JsonOrganization> organizations = OpenTrialsXsltFunctions.getOrganizations(jsonOrganizationList);
        String ret = "";
        for (JsonOrganization o : organizations) {
            if (!StringUtils.isNotBlank((String)o.getOrganization_id())) continue;
            ret = ret + o.getOrganization_name() + "@";
            if (o.getOrganization_role().equalsIgnoreCase("primary_sponsor")) {
                ret = ret + "sponsor@@";
                continue;
            }
            ret = ret + o.getOrganization_role() + "@@";
        }
        if (ret.endsWith("@@")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    public static String getTrialLocations(String jsonLocationsList) {
        List<JsonLocation> locations = OpenTrialsXsltFunctions.getLocations(jsonLocationsList);
        String ret = "";
        for (JsonLocation l : locations) {
            if (!StringUtils.isNotBlank((String)l.getLocation_name())) continue;
            ret = ret + l.getLocation_name() + "@@";
        }
        if (ret.endsWith("@@")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    @Deprecated
    public static List<JsonProv> getProvs(String jsonProvList) {
        Gson gson = new Gson();
        Type type = new TypeToken<List<JsonProv>>(){}.getType();
        return (List)gson.fromJson(jsonProvList, type);
    }

    public static List<JsonRecord> getRecords(String jsonRecordsList) {
        Gson gson = new Gson();
        Type type = new TypeToken<List<JsonRecord>>(){}.getType();
        return (List)gson.fromJson(jsonRecordsList, type);
    }

    public static List<JsonPeople> getPeople(String jsonPeopleList) {
        Gson gson = new Gson();
        Type type = new TypeToken<List<JsonPeople>>(){}.getType();
        return (List)gson.fromJson(jsonPeopleList, type);
    }

    public static List<JsonOrganization> getOrganizations(String jsonOrganizationsList) {
        Gson gson = new Gson();
        Type type = new TypeToken<List<JsonOrganization>>(){}.getType();
        return (List)gson.fromJson(jsonOrganizationsList, type);
    }

    public static List<JsonLocation> getLocations(String jsonLocationsList) {
        Gson gson = new Gson();
        Type type = new TypeToken<List<JsonLocation>>(){}.getType();
        return (List)gson.fromJson(jsonLocationsList, type);
    }

    static class JsonLocation {
        String location_name;

        JsonLocation() {
        }

        public String getLocation_name() {
            return this.location_name;
        }

        public void setLocation_name(String location_name) {
            this.location_name = location_name;
        }
    }

    static class JsonOrganization {
        String organization_name;
        String organization_id;
        String organization_role;

        JsonOrganization() {
        }

        public String getOrganization_name() {
            return this.organization_name;
        }

        public void setOrganization_name(String organization_name) {
            this.organization_name = organization_name;
        }

        public String getOrganization_id() {
            return this.organization_id;
        }

        public void setOrganization_id(String organization_id) {
            this.organization_id = organization_id;
        }

        public String getOrganization_role() {
            return this.organization_role;
        }

        public void setOrganization_role(String organization_role) {
            this.organization_role = organization_role;
        }
    }

    static class JsonPeople {
        String person_name;
        String person_id;
        String person_role;

        JsonPeople() {
        }

        public String getPerson_name() {
            return this.person_name;
        }

        public void setPerson_name(String person_name) {
            this.person_name = person_name;
        }

        public String getPerson_id() {
            return this.person_id;
        }

        public void setPerson_id(String person_id) {
            this.person_id = person_id;
        }

        public String getPerson_role() {
            return this.person_role;
        }

        public void setPerson_role(String person_role) {
            this.person_role = person_role;
        }
    }

    static class JsonRecord {
        String source_id;
        String source_url;
        boolean is_primary;

        JsonRecord() {
        }

        public String getSource_id() {
            return this.source_id;
        }

        public String getSource_url() {
            return this.source_url;
        }

        public void setSource_id(String source_id) {
            this.source_id = source_id;
        }

        public void setSource_url(String source_url) {
            this.source_url = source_url;
        }

        public boolean isIs_primary() {
            return this.is_primary;
        }

        public void setIs_primary(boolean is_primary) {
            this.is_primary = is_primary;
        }
    }

    @Deprecated
    static class JsonProv {
        String url;
        String sourceId;
        String sourceName;

        JsonProv() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }
    }
}

