/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.SpecialTrustProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.AuthorMerger;
import eu.dnetlib.data.transform.DatePicker;
import eu.dnetlib.data.transform.OafUtils;
import eu.dnetlib.data.transform.TrustOrdering;
import eu.dnetlib.pace.config.DedupConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class OafEntityMerger {
    private static final String DEDUP_CLASSID = "sysimport:dedup";
    private static final String DNET_PROVENANCE_SCHEME = "dnet:provenanceActions";
    private final Predicate<FieldTypeProtos.StringField> skipEmptyStringField = s -> s != null && s.getValue() != null && !s.getValue().isEmpty();
    private final Predicate<String> skipEmptyString = s -> StringUtils.isNotBlank((String)s);

    public static OafProtos.Oaf.Builder merge(String id, Iterable<OafProtos.Oaf> entities) {
        return OafEntityMerger.merge(null, id, entities);
    }

    public static OafProtos.Oaf.Builder merge(DedupConfig dedupConf, String id, Iterable<OafProtos.Oaf> entities) {
        return new OafEntityMerger().mergeEntities(dedupConf, id, entities);
    }

    public static OafProtos.Oaf.Builder merge(OafProtos.Oaf.Builder builder) {
        return new OafEntityMerger().doMergeEntities(builder);
    }

    public OafProtos.Oaf.Builder mergeEntities(DedupConfig dedupConf, String id, Iterable<OafProtos.Oaf> entities) {
        ResultProtos.Result.Metadata.Builder mb;
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder();
        String trust = "0.0";
        ArrayList dateofacceptance = Lists.newArrayList();
        ArrayList authors = Lists.newArrayList();
        ArrayList alternativenames = Lists.newArrayList();
        for (OafProtos.Oaf oaf : TrustOrdering.sort(entities)) {
            ResultProtos.Result.Metadata mb2;
            if (!oaf.getKind().equals((Object)KindProtos.Kind.entity)) {
                throw new IllegalArgumentException("expected OafEntity!");
            }
            String currentTrust = oaf.getDataInfo().getTrust();
            if (!currentTrust.equals(SpecialTrustProtos.SpecialTrust.NEUTRAL.toString())) {
                trust = currentTrust;
            }
            builder.mergeFrom(oaf);
            if (oaf.getEntity().getType().equals((Object)TypeProtos.Type.result)) {
                mb2 = oaf.getEntity().getResult().getMetadata();
                dateofacceptance.add(mb2.getDateofacceptance().getValue());
                authors.add(mb2.getAuthorList());
            }
            if (!oaf.getEntity().getType().equals((Object)TypeProtos.Type.organization)) continue;
            mb2 = oaf.getEntity().getOrganization().getMetadata();
            alternativenames.add(mb2.getLegalname());
            alternativenames.add(mb2.getLegalshortname());
            if (mb2.getAlternativeNamesCount() <= 0) continue;
            alternativenames.addAll(mb2.getAlternativeNamesList());
        }
        builder = this.doMergeEntities(builder);
        builder.getEntityBuilder().setId(id);
        builder.getDataInfoBuilder().setInvisible(false).setInferred(true).setDeletedbyinference(false).setTrust(trust).setInferenceprovenance(dedupConf != null ? dedupConf.getWf().getConfigurationId() : "").setProvenanceaction(this.getProvenanceAction());
        if (builder.getEntity().getType().equals((Object)TypeProtos.Type.result)) {
            mb = builder.getEntityBuilder().getResultBuilder().getMetadataBuilder();
            mb.setDateofacceptance(DatePicker.pick(dateofacceptance));
            mb.clearAuthor().addAllAuthor(AuthorMerger.merge(authors));
        }
        if (builder.getEntity().getType().equals((Object)TypeProtos.Type.organization) && !alternativenames.isEmpty()) {
            mb = builder.getEntityBuilder().getOrganizationBuilder().getMetadataBuilder();
            mb.clearAlternativeNames();
            mb.addAllAlternativeNames(alternativenames.stream().filter(sf -> StringUtils.isNotBlank((String)sf.getValue())).collect(Collectors.toMap(FieldTypeProtos.StringField::getValue, sf -> sf, (s1, s2) -> s2)).values());
        }
        if (dedupConf != null && dedupConf.getWf().isIncludeChildren()) {
            for (OafProtos.Oaf oaf : Iterables.limit(entities, (int)dedupConf.getWf().getMaxChildren())) {
                builder.getEntityBuilder().addChildren(oaf.getEntity());
            }
        }
        return builder;
    }

    private FieldTypeProtos.Qualifier.Builder getProvenanceAction() {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(DEDUP_CLASSID).setClassname(DEDUP_CLASSID).setSchemeid(DNET_PROVENANCE_SCHEME).setSchemename(DNET_PROVENANCE_SCHEME);
    }

    public OafProtos.Oaf.Builder doMergeEntities(OafProtos.Oaf.Builder builder) {
        for (String field : OafUtils.getFieldNames(OafProtos.OafEntity.getDescriptor(), 9)) {
            this.setKeyValues((Message.Builder)builder.getEntityBuilder(), field);
        }
        for (String field : OafUtils.getFieldNames(OafProtos.OafEntity.getDescriptor(), 10)) {
            this.setStructuredProperty((Message.Builder)builder.getEntityBuilder(), field);
        }
        for (String field : OafUtils.getFieldNames(OafProtos.OafEntity.getDescriptor(), 8)) {
            this.setUniqueString((Message.Builder)builder.getEntityBuilder(), field);
        }
        switch (builder.getEntity().getType()) {
            case datasource: {
                break;
            }
            case organization: {
                break;
            }
            case project: {
                break;
            }
            case result: {
                ResultProtos.Result.Metadata.Builder result = builder.getEntityBuilder().getResultBuilder().getMetadataBuilder();
                this.setTitle(result);
                this.mergeInstances(builder.getEntityBuilder().getResultBuilder());
                for (String field : OafUtils.getFieldNames(ResultProtos.Result.Metadata.getDescriptor(), 1, 3)) {
                    this.setStructuredProperty((Message.Builder)result, field);
                }
                for (String field : OafUtils.getFieldNames(ResultProtos.Result.Metadata.getDescriptor(), 25)) {
                    this.setLongestStringField((Message.Builder)result, field);
                }
                for (String field : OafUtils.getFieldNames(ResultProtos.Result.Metadata.getDescriptor(), 27)) {
                    this.setUniqueStringField((Message.Builder)result, field);
                }
                this.mergeContexts(result);
                this.mergeCountries(result);
                break;
            }
        }
        return builder;
    }

    private void mergeCountries(ResultProtos.Result.Metadata.Builder result) {
        HashMap cMap = Maps.newHashMap();
        for (FieldTypeProtos.Qualifier country : result.getCountryList()) {
            if (cMap.containsKey(country.getClassid())) continue;
            cMap.put(country.getClassid(), FieldTypeProtos.Qualifier.newBuilder((FieldTypeProtos.Qualifier)country));
        }
        if (!cMap.isEmpty()) {
            result.clearCountry();
            for (FieldTypeProtos.Qualifier country : cMap.values()) {
                result.addCountry(country.build());
            }
        }
    }

    private void mergeContexts(ResultProtos.Result.Metadata.Builder result) {
        HashMap cMap = Maps.newHashMap();
        for (ResultProtos.Result.Context c : result.getContextList()) {
            if (cMap.containsKey(c.getId())) continue;
            cMap.put(c.getId(), ResultProtos.Result.Context.newBuilder((ResultProtos.Result.Context)c));
        }
        if (!cMap.isEmpty()) {
            result.clearContext();
            for (ResultProtos.Result.Context.Builder b : cMap.values()) {
                result.addContext(b.build());
            }
        }
    }

    private void mergeInstances(ResultProtos.Result.Builder builder) {
        HashMap map = Maps.newHashMap();
        for (ResultProtos.Result.Instance i : builder.getInstanceList()) {
            String key = i.getHostedby().getKey() + i.getAccessright().getClassid() + i.getInstancetype().getClassid();
            if (!map.containsKey(key)) {
                map.put(key, ResultProtos.Result.Instance.newBuilder().mergeFrom(i));
                continue;
            }
            ((ResultProtos.Result.Instance.Builder)map.get(key)).addAllUrl((Iterable)i.getUrlList());
        }
        for (ResultProtos.Result.Instance i : map.values()) {
            HashSet urls = Sets.newHashSet();
            urls.addAll(i.getUrlList());
            i.clearUrl().addAllUrl((Iterable)urls);
        }
        builder.clearInstance();
        builder.addAllInstance(Iterables.transform(map.values(), b -> b.build()));
    }

    private void setStructuredProperty(Message.Builder builder, String fieldName) {
        HashMap map = Maps.newHashMap();
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List sps = (List)builder.getField(fd);
        if (sps != null && !sps.isEmpty()) {
            for (FieldTypeProtos.StructuredProperty sp : sps) {
                if (!StringUtils.isNotBlank((String)sp.getValue())) continue;
                map.put(sp.getValue().toLowerCase(), sp);
            }
            if (!map.isEmpty()) {
                builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
            }
        }
    }

    private void setKeyValues(Message.Builder builder, String fieldName) {
        HashMap map = Maps.newHashMap();
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List kvs = (List)builder.getField(fd);
        if (kvs != null && !kvs.isEmpty()) {
            for (FieldTypeProtos.KeyValue sp : kvs) {
                map.put(sp.getKey(), sp);
            }
            if (!map.isEmpty()) {
                builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
            }
        }
    }

    private void setSingleString(Message.Builder builder, String fieldName) {
        FieldTypeProtos.StringField s;
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        if (field != null && !field.isEmpty() && (s = (FieldTypeProtos.StringField)Iterables.getLast((Iterable)Iterables.filter((Iterable)field, this.skipEmptyStringField), (Object)"")) != null && s.getValue() != null && !s.getValue().isEmpty()) {
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Object[])new FieldTypeProtos.StringField[]{s}));
        }
    }

    private void setLongestStringField(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        if (field != null && !field.isEmpty()) {
            FieldTypeProtos.StringField.Builder max = FieldTypeProtos.StringField.newBuilder().setValue("");
            int maxLength = 0;
            for (FieldTypeProtos.StringField sf : field) {
                if (sf.getValue().length() <= maxLength) continue;
                maxLength = sf.getValue().length();
                max.clear();
                max.mergeFrom(sf);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Object[])new FieldTypeProtos.StringField[]{max.build()}));
        }
    }

    private void setUniqueStringField(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        HashMap map = Maps.newHashMap();
        if (field != null && !field.isEmpty()) {
            for (FieldTypeProtos.StringField s : Iterables.filter((Iterable)field, this.skipEmptyStringField)) {
                map.put(s.getValue(), s);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
        }
    }

    private void setUniqueString(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        HashSet set = Sets.newHashSet();
        if (field != null && !field.isEmpty()) {
            for (String s : Iterables.filter((Iterable)field, this.skipEmptyString)) {
                set.add(s);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Iterable)set));
        }
    }

    private void setTitle(ResultProtos.Result.Metadata.Builder metadata) {
        Iterable filtered = Iterables.filter((Iterable)metadata.getTitleList(), OafUtils.mainTitleFilter());
        if (!Iterables.isEmpty((Iterable)filtered)) {
            metadata.clearTitle().addTitle((FieldTypeProtos.StructuredProperty)Iterables.getLast((Iterable)filtered));
        }
    }
}

