/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.index;

import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.functionality.index.solr.feed.StreamingInputDocumentFactory;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.Closeable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

public class CloudIndexClient
implements Closeable {
    private static final Log log = LogFactory.getLog(CloudIndexClient.class);
    private static final String INDEX_RECORD_RESULT_FIELD = "dnetResult";
    private final CloudSolrClient solrClient;

    protected CloudIndexClient(CloudSolrClient solrServer) {
        this.solrClient = solrServer;
    }

    public int feed(String record, String indexDsId, UnaryFunction<String, String> toIndexRecord) throws CloudIndexClientException {
        return this.feed(record, indexDsId, toIndexRecord, true);
    }

    public int feed(String record, String indexDsId, UnaryFunction<String, String> toIndexRecord, boolean commit) throws CloudIndexClientException {
        try {
            SolrInputDocument doc = this.prepareSolrDocument(record, indexDsId, toIndexRecord);
            if (doc == null || doc.isEmpty()) {
                throw new CloudIndexClientException("Invalid solr document");
            }
            return this.feed(doc, commit);
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding document", e);
        }
    }

    public int feed(SolrInputDocument document) throws CloudIndexClientException {
        return this.feed(document, true);
    }

    public int feed(SolrInputDocument document, boolean commit) throws CloudIndexClientException {
        try {
            UpdateResponse res = this.solrClient.add(document);
            log.debug((Object)("feed time for single records, elapsed time: " + HumanTime.exactly((long)res.getElapsedTime())));
            if (res.getStatus() != 0) {
                throw new CloudIndexClientException("bad status: " + res.getStatus());
            }
            if (commit) {
                this.solrClient.commit();
            }
            return res.getStatus();
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding document", e);
        }
    }

    public void feed(List<SolrInputDocument> docs, AfterFeedingCallback callback) throws CloudIndexClientException {
        this.feed(docs, callback, true);
    }

    public void feed(List<SolrInputDocument> docs, AfterFeedingCallback callback, boolean commit) throws CloudIndexClientException {
        try {
            if (docs.isEmpty()) {
                log.debug((Object)"Empty list of documents. Calling callback, if needed.");
                if (callback != null) {
                    callback.doAfterFeeding(null);
                }
                return;
            }
            UpdateResponse res = this.solrClient.add(docs);
            log.debug((Object)("feed time for " + docs.size() + " records, elapsed tipe: : " + HumanTime.exactly((long)res.getElapsedTime())));
            if (commit) {
                this.solrClient.commit();
            }
            if (callback != null) {
                callback.doAfterFeeding(res);
            }
            if (res.getStatus() != 0) {
                throw new CloudIndexClientException("bad status: " + res.getStatus());
            }
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding documents", e);
        }
    }

    public SolrInputDocument prepareSolrDocument(String record, String indexDsId, UnaryFunction<String, String> toIndexRecord) throws CloudIndexClientException {
        try {
            StreamingInputDocumentFactory documentFactory = new StreamingInputDocumentFactory();
            String version = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'").format(new Date());
            String indexRecord = (String)toIndexRecord.evaluate((Object)record);
            if (log.isDebugEnabled()) {
                log.debug((Object)("***************************************\nSubmitting index record:\n" + indexRecord + "\n***************************************\n"));
            }
            return documentFactory.parseDocument(version, indexRecord, indexDsId, INDEX_RECORD_RESULT_FIELD);
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error creating solr document", e);
        }
    }

    public boolean isRecordIndexed(String id) throws CloudIndexClientException {
        QueryResponse res = this.query("objidentifier:\"" + id + "\"", null);
        return res.getResults().size() > 0;
    }

    public int remove(String id) throws CloudIndexClientException {
        return this.remove(id, true);
    }

    public int remove(String id, boolean commit) throws CloudIndexClientException {
        String q = String.format("objidentifier:\"%s\" OR resultdupid:\"%s\"", id, id);
        try {
            UpdateResponse res = this.solrClient.deleteByQuery(q);
            if (commit) {
                this.solrClient.commit();
            }
            return res.getResponse().size();
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error removing documents", e);
        }
    }

    public int count(String query) throws CloudIndexClientException {
        QueryResponse res = this.query(query, 0);
        return res.getResults().size();
    }

    public QueryResponse query(String query, Integer rows) throws CloudIndexClientException {
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            if (rows != null && rows >= 0) {
                solrQuery.setRows(rows);
            }
            return this.solrClient.query((SolrParams)solrQuery);
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error searching documents", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.solrClient != null) {
            this.solrClient.close();
        }
    }

    public void commit() throws CloudIndexClientException {
        if (this.solrClient != null) {
            try {
                this.solrClient.commit();
            }
            catch (IOException | SolrServerException e) {
                throw new CloudIndexClientException(e.getMessage());
            }
        }
    }

    public static interface AfterFeedingCallback {
        public void doAfterFeeding(UpdateResponse var1);
    }
}

