package eu.dnetlib.data.transform.xml;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Maps;

public class Element {

	private String text;
	private Map<String, String> attributes;

	public Element(final String text, final Map<String, String> attributes) {
		this.text = text;
		this.attributes = attributes;
	}

	public Element(final String text) {
		this.text = text;
		this.attributes = Maps.newHashMap();
	}

	public Element() {
		this.text = "";
		this.attributes = Maps.newHashMap();
	}

	public String getText() {
		return text;
	}

	public void setText(final String text) {
		this.text = text;
	}

	public Map<String, String> getAttributes() {
		return attributes;
	}

	public String getAttributeValue(final String attributeName) {
		return getAttributes().get(attributeName);
	}

	public void setAttributes(final Map<String, String> attributes) {
		this.attributes = attributes;
	}

	public boolean isEmpty() {
		return !(hasText() || hasAttributes());
	}

	private boolean hasAttributes() {
		return (getAttributes() != null) && !getAttributes().isEmpty();
	}

	public boolean hasText() {
		return (getText() != null) && !getText().isEmpty();
	}

	@Override
	public String toString() {
		return "{ " + StringUtils.left(text, 20) + attributes.toString() + " }";
	}
}
