package eu.dnetlib.data.mapreduce.util;

import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.RelTypeProtos.SubRelType;

public class RelDescriptor {

	public static final String SEPARATOR = "_";

	private final String it;

	// relType also corresponds to the Ontology code
	private final RelType relType;

	private final SubRelType subRelType;

	private final String relClass;


	// <TERM code="hasAmongTopNSimilarDocuments" encoding="resultResult_similarity_hasAmongTopNSimilarDocuments"
	//final String rd = oafRel.getRelType().toString() + "_" + oafRel.getSubRelType() + "_" + relClasses.getInverse(oafRel.getRelClass());
	//<ONTOLOGY_NAME code="dnet:result_result_relations">
	public RelDescriptor(final String value) {
		super();
		this.it = value;

		String[] s = value.split(SEPARATOR);

		this.relType = RelType.valueOf(s[0]);
		this.subRelType = SubRelType.valueOf(s[1]);
		this.relClass = s[2];

	}

	public SubRelType getSubRelType() {
		return subRelType;
	}

	public RelType getRelType() {
		return relType;
	}

	public String getRelClass() {
		return relClass;
	}

	public String getIt() {
		return it;
	}


	@Override
	public String toString() {
		return getIt();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (prime * result) + ((it == null) ? 0 : it.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		RelDescriptor other = (RelDescriptor) obj;
		if (it == null) {
			if (other.it != null) return false;
		} else if (!it.equals(other.it)) return false;
		return true;
	}

}
