package eu.dnetlib.msro.openaireplus.workflows.nodes;

import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class ObtainOpenaireDataSourceParamsJobNode extends SimpleJobNode {

	private String providerId;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String query = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='" + providerId + "']//EXTRA_FIELDS\n"
				+ "return concat($x/FIELD[./key='OpenAireDataSourceId']/value, ' @@@ ', $x/FIELD[./key='NamespacePrefix']/value)";

		final String[] arr = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query).split("@@@");

		final String origId = arr[0].trim();
		final String nsPrefix = arr[1].trim();
		//this is needed by the mdbuilder
		//TODO: update mdbuilder to use the env attributes below, whose names are defined in WorkflowConstants
		token.getEnv().setAttribute("parentDatasourceId", origId);
		token.getEnv().setAttribute("namespacePrefix", nsPrefix);
		token.getEnv().setAttribute("dateOfCollection", DateUtils.now_ISO8601());

		//these are needed for validation and fill hostedby
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, origId);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);

		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, origId);
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);

		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, origId);
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);

		return Arc.DEFAULT_ARC;

	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(final String providerId) {
		this.providerId = providerId;
	}

}
