package eu.dnetlib.msro.openaireplus.workflows.nodes.bulktag;

import com.google.common.base.Joiner;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.bulktag.CommunityConfigurationFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

public class LoadBulkTaggingConfigurationJobNode extends SimpleJobNode {

    private static final Log log = LogFactory.getLog(LoadBulkTaggingConfigurationJobNode.class);

    @Autowired
    private UniqueServiceLocator serviceLocator;

    private String xquery;

    private String bulkTaggingConfParam;

    private String enabledConfParam;

    private boolean enabled;

    @Override
    protected String execute(final NodeToken token) throws Exception {

        final List<String> res = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(getXquery());

        final String xmlConf = "<communities>" + Joiner.on(" ").join(res) + "</communities>";

        token.getEnv().setAttribute(getBulkTaggingConfParam(), CommunityConfigurationFactory.newInstance(xmlConf).toJson());
        token.getEnv().setAttribute(getEnabledConfParam(),isEnabled());

        return Arc.DEFAULT_ARC;
    }

    public String getXquery() {
        log.debug(xquery);
        return xquery;
    }

    public void setXquery(final String xquery) {
        this.xquery = xquery;

    }

    public String getBulkTaggingConfParam() {
        return bulkTaggingConfParam;
    }

    public void setBulkTaggingConfParam(final String bulkTaggingConfParam) {
        this.bulkTaggingConfParam = bulkTaggingConfParam;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getEnabledConfParam() {
        return enabledConfParam;
    }

    public void setEnabledConfParam(String enabledConfParam) {
        this.enabledConfParam = enabledConfParam;
    }

}