<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" version="2.0"
                exclude-result-prefixes="fn">

    <xsl:variable name="namespacePrefix" select="string('sgov________')"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::SGOV')"/>

    <xsl:template name="FirstLetterAndNumber">
        <xsl:param name="string" select="normalize-space(translate(., ', ', ' '))"/>

        <xsl:for-each select="tokenize($string, ' ')">
            <xsl:if test="string-length(.) != 0">
                <xsl:variable name="char" select="substring(., 1, 1)"/>
                <xsl:if test="fn:upper-case($char)=$char">
                    <xsl:value-of select="$char"/>
                </xsl:if>

            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="/">
        <fundings>
            <fundingtree>
                <funder>
                    <id>
                        <xsl:value-of select="$funderID"/>
                    </id>
                    <shortname>SGOV</shortname>
                    <name>Gobierno de España</name>
                    <jurisdiction>ES</jurisdiction>
                </funder>
                <xsl:variable name="stream">
                    <xsl:call-template name="FirstLetterAndNumber">
                        <xsl:with-param name="string" select=".//column[@name = 'Entidad Convocante']"/>
                    </xsl:call-template>

                </xsl:variable>
                <xsl:variable name="streaml1">
                    <xsl:call-template name="FirstLetterAndNumber">
                        <xsl:with-param name="string" select=".//column[@name = 'Unidad Directiva']"/>
                    </xsl:call-template>
                </xsl:variable>
                <funding_level_1>
                    <id>
                        <xsl:value-of select="concat($funderID, '::', $stream,'::',$streaml1)"/>
                    </id>
                    <description>
                        <xsl:value-of select=".//column[@name='Unidad Directiva']"/>
                    </description>
                    <name>
                        <xsl:value-of select=".//column[@name='Unidad Directiva']"/>
                    </name>
                    <class>
                        <xsl:value-of select="concat('sgov:',fn:lower-case($streaml1),'fundings')"/></class>
                    <parent>
                        <funding_level_0>
                            <id>
                                <xsl:value-of select="concat($funderID, '::',$stream)"/>
                            </id>
                            <name><xsl:value-of select=".//column[@name='Entidad Convocante']"/></name>
                            <description><xsl:value-of select=".//column[@name='Entidad Convocante']"/></description>
                            <parent/>
                            <class>
                                <xsl:value-of select="concat('sgov:',fn:lower-case($stream),'fundings')"/>
                            </class>
                        </funding_level_0>
                    </parent>
                </funding_level_1>
            </fundingtree>
        </fundings>
    </xsl:template>

</xsl:stylesheet>