CREATE TABLE IF NOT EXISTS hostedby_map (
	_dnet_resource_identifier_ CHARACTER VARYING(2048) DEFAULT 'temp_' || md5(clock_timestamp() :: TEXT) || '_' || md5(random() :: TEXT) UNIQUE,
	oa_source_id               CHARACTER VARYING(255) REFERENCES dsm_datasources (id),
	entry                      CHARACTER VARYING(255) NOT NULL,
	datasourceid               CHARACTER VARYING(255) REFERENCES dsm_datasources (id),
	PRIMARY KEY (oa_source_id, entry)
);

--DATACITE API
INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass)
VALUES ('api_________::datacite::oaisets', 'api_________::datacite::oaisets', 'oai_sets', 'openaire____::datacite', 'aggregator::datarepository', 'native');
INSERT INTO apicollections (param, original, api) VALUES ('baseUrl', 'http://oai.datacite.org/oai', 'api_________::datacite::oaisets');
INSERT INTO apicollections (param, original, api, accessparam)
VALUES ('metadata_identifier_path', '//*[local-name() = ''setSpec'']', 'api_________::datacite::oaisets', FALSE);

--PANGAEA BY PROJECT
INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES
	('api_________::re3data_____::r3d100010134::pangaeabyproject', 'api_________::re3data_____::r3d100010134::pangaeabyproject', 'datasetsbyproject',
	 're3data_____::r3d100010134', 'datarepository::unknown', 'native');
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('metadata_identifier_path', '//*[local-name()=''header'']/*[local-name()=''identifier'']', 'api_________::re3data_____::r3d100010134::pangaeabyproject',
	 'api_________::re3data_____::r3d100010134::pangaeabyproject@@metadata_identifier_path', FALSE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('baseUrl', 'file:///var/lib/dnet/pangaea_projects.csv', 'api_________::re3data_____::r3d100010134::pangaeabyproject',
	 'api_________::re3data_____::r3d100010134::pangaeabyproject@@baseUrl', TRUE);

--PANGAEA BY JOURNAL

INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES
	('api_________::re3data_____::r3d100010134::pangaeabyjournal', 'api_________::re3data_____::r3d100010134::pangaeabyjournal', 'datasetsbyjournal',
	 're3data_____::r3d100010134', 'datarepository::unknown', 'native');
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('metadata_identifier_path', '//*[local-name()=''header'']/*[local-name()=''identifier'']', 'api_________::re3data_____::r3d100010134::pangaeabyjournal',
	 'api_________::re3data_____::r3d100010134::pangaeabyjournal@@metadata_identifier_path', FALSE);

INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES
	('api_________::re3data_____::r3d100010134::pangaeabyjournalCSV', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV', 'fileCSV',
	 're3data_____::r3d100010134', 'datarepository::unknown', 'native');
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('metadata_identifier_path', '//*[local-name()=''column'' and @isID=''true'']', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV',
	 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@metadata_identifier_path', FALSE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('baseUrl', 'file:///var/lib/dnet/pangaea_journals.csv', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV',
	 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@baseUrl', TRUE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('quote', '"', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@quote', TRUE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('header', 'true', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@header',
	 TRUE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('identifier', '4', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV',
	 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@identifier', TRUE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('separator', '@', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV',
	 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@separator', TRUE);

--DOAJ

INSERT INTO api (id, _dnet_resource_identifier_, protocolclass, datasource, contentdescriptionclass, typologyclass, compatibilityclass) VALUES
	('api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV',
	 'httpCSV', 'driver______::1790119e-d281-4b7a-aedf-866d1d853a07', 'metadata', 'entityregistry', 'native');

INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('baseUrl', 'http://doaj.org/csv', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV',
	 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@baseUrl', TRUE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('separator', ',', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV',
	 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@separator', TRUE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('quote', '"', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV',
	 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@quote', TRUE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('identifier', 'ISSN', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV',
	 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@identifier', TRUE);
INSERT INTO apicollections (param, original, api, _dnet_resource_identifier_, accessparam) VALUES
	('metadata_identifier_path', '//column[./@isID=''true'']', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV',
	 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@metadata_identifier_path', FALSE);


CREATE TABLE IF NOT EXISTS hostedby_props (
	_dnet_resource_identifier_ CHARACTER VARYING(2048) NOT NULL REFERENCES hostedby_map (_dnet_resource_identifier_),
	key                        CHARACTER VARYING(255)  NOT NULL,
	value                      CHARACTER VARYING(255)  NOT NULL,
	PRIMARY KEY (_dnet_resource_identifier_, key, value)
);