package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/**
 * Created by alessia on 01/02/16.
 */
public class PrepareHostedbyUpdateSQL extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(PrepareHostedbyUpdateSQL.class);
	private String updateSqlTemplatePath;
	private String theQueryParamName = "hostedByUpdateSQL";

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String datasourceId = token.getEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID);
		final String datasourceNamespacePrefix = token.getEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX);
		final Resource updateSqlTemplate = new ClassPathResource(updateSqlTemplatePath);
		final StringTemplate st = new StringTemplate(IOUtils.toString(updateSqlTemplate.getInputStream()));
		st.setAttribute("datasourceId", datasourceId);
		st.setAttribute("datasourceNamespacePrefix", datasourceNamespacePrefix);
		final String theQuery = st.toString();
		log.debug("Generated query: " + theQuery);
		token.getFullEnv().setAttribute(theQueryParamName, theQuery);
		return Arc.DEFAULT_ARC;
	}

	public String getUpdateSqlTemplatePath() {
		return updateSqlTemplatePath;
	}

	public void setUpdateSqlTemplatePath(final String updateSqlTemplatePath) {
		this.updateSqlTemplatePath = updateSqlTemplatePath;
	}

	public String getTheQueryParamName() {
		return theQueryParamName;
	}

	public void setTheQueryParamName(final String theQueryParamName) {
		this.theQueryParamName = theQueryParamName;
	}
}
