package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import java.util.List;
import javax.annotation.Resource;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

/**
 * Superceded by eu.dnetlib.msro.openaireplus.workflows.nodes.index.FindSearchServicesJobNode.
 *
 * @author claudio, alessia
 * @see eu.dnetlib.msro.openaireplus.workflows.nodes.index.FindSearchServicesJobNode
 * @deprecated
 */
@Deprecated
public class FindSearchServiceJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(FindSearchServiceJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Value(value = "${dnet.openaire.service.search.lookup.xquery}")
	private String xquery;

	private String xqueryForServiceIdParam;

	/**
	 * {@inheritDoc}
	 *
	 * @throws ISLookUpException
	 * @throws MSROException
	 * @see com.googlecode.sarasvati.mem.MemNode#execute(com.googlecode.sarasvati.Engine, com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	public String execute(final NodeToken token) throws ISLookUpException, MSROException {

		log.info("lookup for search service: " + getXquery());

		List<String> searchServiceIds = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(getXquery());

		if (searchServiceIds.size() > 1) { throw new MSROException("too many search services: " + searchServiceIds); }

		if (searchServiceIds.isEmpty()) {
			return "notFound";
		} else {
			token.getEnv().setAttribute(getXqueryForServiceIdParam(), getXquery());
			return "found";
		}
	}

	public String getXquery() {
		return xquery;
	}

	public void setXquery(final String xquery) {
		this.xquery = xquery;
	}

	public String getXqueryForServiceIdParam() {
		return xqueryForServiceIdParam;
	}

	public void setXqueryForServiceIdParam(final String xqueryForServiceIdParam) {
		this.xqueryForServiceIdParam = xqueryForServiceIdParam;
	}

}
