package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp.message;

import java.util.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.dhp.message.Message;
import eu.dnetlib.msro.rmi.MSROException;

public class DnetMessageManager {

	private static final Log log = LogFactory.getLog(DnetMessageManager.class);

	private final Map<String, Message> ongoingMessages = Collections.synchronizedMap(new LinkedHashMap<>());

	private final Map<String, Message> reportMessages = Collections.synchronizedMap(new LinkedHashMap<>());

	private long maxNumberOfMessages;

	public synchronized void registerMessage(final Message message) throws MSROException {
		log.debug(String.format("Received %s message wfId: %s", message.getMessageType(), message.getWorkflowId()));

		if (Objects.isNull(message.getMessageType())) {
			throw new MSROException("missing message type in: " + message.toString());
		}
		switch (message.getMessageType()) {
			case ONGOING:
				ongoingMessages.put(message.getWorkflowId(), message);
				if (ongoingMessages.size() > maxNumberOfMessages) {
					ongoingMessages.remove(ongoingMessages.keySet().iterator().next());
				}
				break;
			case REPORT:
				reportMessages.put(message.getWorkflowId(), message);
				if (reportMessages.size() > maxNumberOfMessages) {
					reportMessages.remove(reportMessages.keySet().iterator().next());
				}
				break;
			default:
				throw new MSROException("message type not managed: " + message.getMessageType());
		}
	}

	public Message findOngoingMessage(final String workflowId) {
		return ongoingMessages.get(workflowId);
	}

	public Message findReportMessage(final String workflowId) {
		return reportMessages.get(workflowId);
	}

	protected Map<String, Message> getOngoingMessages() {
		return ongoingMessages;
	}

	protected Map<String, Message> getReportMessages() {
		return reportMessages;
	}

	public long getMaxNumberOfMessages() {
		return maxNumberOfMessages;
	}

	@Required
	public void setMaxNumberOfMessages(final long maxNumberOfMessages) {
		this.maxNumberOfMessages = maxNumberOfMessages;
	}
}
