<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/xpath-functions" version="1.0"
				exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('tubitakf____')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::tubitak')"/>

	<xsl:template match="/">
		<fundings>
			<fundingtree>
				<funder>
					<id>
						<xsl:value-of select="$funderID"/>
					</id>
					<shortname>TUBITAK</shortname>
					<name>Türkiye Bilimsel ve Teknolojik Araştırma Kurumu</name>
					<jurisdiction>TR</jurisdiction>
				</funder>
				<xsl:variable name="stream" select="normalize-space(.//column[@name='FUNDING STREAM(S)'])"/>
				<xsl:if test="string-length($stream) > 0">
					<funding_level_0>
						<id>
							<xsl:value-of select="concat($funderID, '::', $stream)"/>
						</id>

						<description>
							<xsl:value-of select="$stream"/>
						</description>
						<name>
							<xsl:value-of select="$stream"/>
						</name>
						<parent></parent>
						<class>tubitak:fundingStream</class>
					</funding_level_0>
				</xsl:if>
			</fundingtree>
		</fundings>
	</xsl:template>

</xsl:stylesheet>