/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareActionSetsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareActionSetsJobNode.class);
    private String ACTIONSET_PATH_XQUERY_TEMPLATE = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return $x/RESOURCE_PROFILE/BODY/SET[@id = '%s']/@directory/string()";
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String sets;

    protected String execute(NodeToken token) throws Exception {
        List<Map<String, String>> setList = this.getSetList();
        String now = DateUtils.now_ISO8601();
        ISLookUpService lookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String basePath = lookUpService.getResourceProfileByQuery("/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='ActionManagerServiceResourceType']//SERVICE_PROPERTIES/PROPERTY[@key='basePath']/@value/string()");
        for (Map<String, String> set : setList) {
            set.put("rawset", RawSet.newInstance().getId());
            set.put("creationDate", now);
            set.put("path", this.getFullPath(basePath, set, lookUpService));
            if (set.get("enabled").equals("true")) {
                log.info((Object)("preparing set: " + this.simplifySetInfo(set)));
            }
            token.getEnv().setAttribute(set.get("jobProperty"), set.get("rawset"));
        }
        token.getEnv().setAttribute("sets", new Gson().toJson(setList));
        token.getEnv().setAttribute("actionManagerBasePath", basePath);
        return Arc.DEFAULT_ARC;
    }

    private String getFullPath(String basePath, Map<String, String> set, ISLookUpService lookUpService) throws MSROException {
        return new Path(basePath + "/" + this.getPath(set.get("set"), lookUpService) + "/" + set.get("rawset")).toString();
    }

    private String getPath(String setId, ISLookUpService lookUpService) throws MSROException {
        try {
            return lookUpService.getResourceProfileByQuery(String.format(this.ACTIONSET_PATH_XQUERY_TEMPLATE, setId));
        }
        catch (ISLookUpException e) {
            throw new MSROException(String.format("Error obtaining directory from ActionSet profile %s", setId), (Throwable)e);
        }
    }

    private Map<String, String> simplifySetInfo(Map<String, String> set) {
        return Maps.filterKeys(set, (Predicate)new Predicate<String>(){

            public boolean apply(String k) {
                return k.equals("set") || k.equals("rawset");
            }
        });
    }

    protected List<Map<String, String>> getSetList() {
        return (List)new Gson().fromJson(this.getSets(), List.class);
    }

    public String getSets() {
        return this.sets;
    }

    public void setSets(String sets) {
        this.sets = sets;
    }
}

