/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.consistency;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FindInvalidStoresJobNode
extends SimpleJobNode {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private MDStoreDao mdstoreDao;
    @Autowired
    private ObjectStoreDao objDao;
    private static final Log log = LogFactory.getLog(FindInvalidStoresJobNode.class);
    private boolean deleteInvalidStores = false;

    protected String execute(NodeToken token) throws Exception {
        ISLookUpService lookup = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        ISRegistryService registry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        String q1 = "distinct-values(for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType')//PARAM[@category='MDSTORE_ID' or @category='OBJECTSTORE_ID'] return $x/text())";
        String q2 = "for $x in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()";
        String q3 = "for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()";
        HashSet valids = new HashSet(lookup.quickSearchProfile("distinct-values(for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType')//PARAM[@category='MDSTORE_ID' or @category='OBJECTSTORE_ID'] return $x/text())"));
        int countMdstores = 0;
        int countInvalidMdStores = 0;
        int countDeletedMdStores = 0;
        int countObjstores = 0;
        int countInvalidObjStores = 0;
        int countDeletedObjStores = 0;
        for (String id : lookup.quickSearchProfile("for $x in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()")) {
            ++countMdstores;
            if (valids.contains(id)) continue;
            log.warn((Object)("Invalid mdstore: " + id));
            ++countInvalidMdStores;
            if (!this.deleteInvalidStores) continue;
            registry.deleteProfile(id);
            this.mdstoreDao.deleteMDStore(id);
            log.info((Object)" -- Deleted");
            ++countDeletedMdStores;
        }
        for (String id : lookup.quickSearchProfile("for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()")) {
            ++countObjstores;
            if (valids.contains(id)) continue;
            log.warn((Object)("Invalid objstore: " + id));
            ++countInvalidObjStores;
            if (!this.deleteInvalidStores) continue;
            registry.deleteProfile(id);
            this.objDao.deleteObjectStore(id);
            log.info((Object)" -- Deleted");
            ++countDeletedObjStores;
        }
        token.getEnv().setAttribute("mainlog:totalMdStores", (Object)countMdstores);
        token.getEnv().setAttribute("mainlog:invalidMdStores", (Object)countInvalidMdStores);
        token.getEnv().setAttribute("mainlog:deletedMdStores", (Object)countDeletedMdStores);
        token.getEnv().setAttribute("mainlog:totalObjStores", (Object)countObjstores);
        token.getEnv().setAttribute("mainlog:invalidObjStores", (Object)countInvalidObjStores);
        token.getEnv().setAttribute("mainlog:deletedObjStores", (Object)countDeletedObjStores);
        return Arc.DEFAULT_ARC;
    }

    public boolean isDeleteInvalidStores() {
        return this.deleteInvalidStores;
    }

    public void setDeleteInvalidStores(boolean deleteInvalidStores) {
        this.deleteInvalidStores = deleteInvalidStores;
    }
}

