package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by claudio on 21/03/16.
 */
public class RunMDStorePluginJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(RunMDStorePluginJobNode.class);

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String mdId;

	private String pluginName;

	@Override
	protected String obtainServiceId(final NodeToken nodeToken) {
		return serviceLocator.getServiceId(MDStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken nodeToken) throws Exception {
		job.setAction("RUN_PLUGIN");
		job.getParameters().put("plugin.name", getPluginName());
		job.getParameters().put("mdId", getMdId());

		log.debug(job.getParameters());
	}

	public String getMdId() {
		return mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getPluginName() {
		return pluginName;
	}

	public void setPluginName(final String pluginName) {
		this.pluginName = pluginName;
	}
}
