<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('ec__________')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::EC')"/>

	<xsl:template match="/">
		<xsl:variable name="specificProgramName">
			<xsl:value-of select="normalize-space(.//ProjectSpecificProgram)"/>
		</xsl:variable>
		<xsl:variable name="programName">
			<xsl:value-of select="normalize-space(.//ProjectProgram)"/>
		</xsl:variable>
		<xsl:variable name="specificProgramDesc" select=".//ProjectSpecificProgramDescr"/>
		<xsl:variable name="specificProgramId"
		              select="normalize-space(concat($funderID, '::FP7::', $specificProgramName))"/>
		<xsl:variable name="programDesc" select=".//ProjectProgramDescr"/>
		<xsl:variable name="programId"
		              select="concat($funderID, '::FP7::', $specificProgramName, '::', $programName)"/>

		<fundingtree>
			<funder>
				<id>
					<xsl:value-of select="$funderID"/>
				</id>
				<shortname>EC</shortname>
				<name>European Commission</name>
				<jurisdiction>EU</jurisdiction>
			</funder>
			<xsl:choose>
				<xsl:when test="string-length($programName) > 0 and string-length($specificProgramName) > 0">
				<funding_level_2>
				<id>
					<xsl:value-of select="$programId"/>
				</id>
				<description>
					<xsl:value-of select="$programDesc"/>
				</description>
				<name>
					<xsl:value-of select="$programName"/>
				</name>
				<class>ec:program</class>
				<parent>
					<funding_level_1>
						<id>
							<xsl:value-of select="$specificProgramId"/>
						</id>
						<description>
							<xsl:value-of select="$specificProgramDesc"/>
						</description>
						<name>
							<xsl:value-of select="$specificProgramName"/>
						</name>
						<class>ec:specificprogram</class>
						<parent>
							<funding_level_0>
								<id>
									<xsl:value-of select="concat($funderID, '::FP7')"/>
								</id>
								<description>SEVENTH FRAMEWORK PROGRAMME</description>
								<name>FP7</name>
								<parent/>
								<class>ec:frameworkprogram</class>
							</funding_level_0>
						</parent>
					</funding_level_1>
				</parent>
				</funding_level_2>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="string-length($specificProgramName) > 0">
							<funding_level_1>
								<id>
									<xsl:value-of select="$specificProgramId"/>
								</id>
								<description>
									<xsl:value-of select="$specificProgramDesc"/>
								</description>
								<name>
									<xsl:value-of select="$specificProgramName"/>
								</name>
								<class>ec:specificprogram</class>
								<parent>
									<funding_level_0>
										<id>
											<xsl:value-of select="concat($funderID, '::FP7')"/>
										</id>
										<description>SEVENTH FRAMEWORK PROGRAMME</description>
										<name>FP7</name>
										<parent/>
										<class>ec:frameworkprogram</class>
									</funding_level_0>
								</parent>
							</funding_level_1>
						</xsl:when>
						<xsl:otherwise>
							<funding_level_0>
								<id>
									<xsl:value-of select="concat($funderID, '::FP7')"/>
								</id>
								<description>SEVENTH FRAMEWORK PROGRAMME</description>
								<name>FP7</name>
								<parent/>
								<class>ec:frameworkprogram</class>
							</funding_level_0>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</fundingtree>
	</xsl:template>

</xsl:stylesheet>
