/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.dhp.message.Message;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.openaireplus.workflows.nodes.dhp.message.DnetMessageManager;
import eu.dnetlib.msro.workflows.hadoop.SubmitHadoopJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubmitDnetHadoopJobNode
extends SubmitHadoopJobNode
implements ProgressProvider,
ProgressJobNode {
    private static final Log log = LogFactory.getLog(SubmitDnetHadoopJobNode.class);
    @Autowired
    private DnetMessageManager dnetMessageManager;
    private int currentValue = 0;
    private int totalValue = 0;
    private boolean accurate = false;
    private String wfId;

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        this.wfId = token.getProcess().getEnv().getAttribute("system:processId");
        super.prepareJob(job, token);
    }

    private void updateProgressProvider() {
        Message mess = this.dnetMessageManager.findOngoingMessage(this.wfId);
        if (mess != null && mess.getBody() != null) {
            if (mess.getBody().containsKey("current")) {
                try {
                    this.setCurrentValue(Integer.parseInt((String)mess.getBody().get("current")));
                }
                catch (Throwable e) {
                    log.error((Object)"Error parsing value", e);
                }
            }
            if (mess.getBody().containsKey("total")) {
                try {
                    this.setTotalValue(Integer.parseInt((String)mess.getBody().get("total")));
                    this.setAccurate(true);
                }
                catch (Throwable e) {
                    log.error((Object)"Error parsing value", e);
                }
            }
        }
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            protected void onDone(BlackboardJob job) {
                super.onDone(this.getOozieWorkflowReport(job));
            }

            protected void onFailed(BlackboardJob job) {
                super.onFailed(this.getOozieWorkflowReport(job));
            }

            private BlackboardJob getOozieWorkflowReport(BlackboardJob job) {
                Message report = SubmitDnetHadoopJobNode.this.dnetMessageManager.findReportMessage(SubmitDnetHadoopJobNode.this.wfId);
                if (Objects.isNull(report)) {
                    log.error((Object)("cannot find report for workflow id: " + SubmitDnetHadoopJobNode.this.wfId));
                } else {
                    report.getBody().forEach((k, v) -> log.info((Object)String.format("%s - %s", k, v)));
                    job.getParameters().putAll(report.getBody());
                }
                return job;
            }
        };
    }

    public ProgressProvider getProgressProvider() {
        return this;
    }

    public String getWfId() {
        return this.wfId;
    }

    public void setWfId(String wfId) {
        this.wfId = wfId;
    }

    public boolean isAccurate() {
        return this.accurate;
    }

    public void setAccurate(boolean accurate) {
        this.accurate = accurate;
    }

    public int getCurrentValue() {
        this.updateProgressProvider();
        return this.currentValue;
    }

    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public int getTotalValue() {
        return this.totalValue;
    }

    public void setTotalValue(int totalValue) {
        this.totalValue = totalValue;
    }

    public boolean isInaccurate() {
        return !this.accurate;
    }
}

