/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.schema.mdstore.Provenance;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PrepareEnvValidationAlertsHadoopJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareEnvValidationAlertsHadoopJobNode.class);
    @Autowired
    private LocalDatasourceManager<?, ?> dsManager;
    private String mdId;
    @Value(value="${dnet.openaire.dhp.validationAlerts.app.path}")
    private String oozieWfPath;
    @Value(value="${dnet.openaire.dhp.validationAlerts.data.path}")
    private String hdfsValidationAlertsDir;
    @Value(value="${dnet.openaire.dhp.validationAlerts.index.name}")
    private String validationAlertsIndexName;
    @Value(value="${dnet.openaire.dhp.validationAlerts.index.host}")
    private String validationAlertsIndexHost;
    @Value(value="${dnet.openaire.dhp.validationAlerts.broker.url}")
    private String brokerBaseUrl;
    private String overrideSubscribers;

    protected String execute(NodeToken token) throws Exception {
        String dsId = token.getEnv().getAttribute("parentDatasourceId");
        log.info((Object)("dsId: " + dsId));
        String apiId = token.getEnv().getAttribute("dataprovider:interface");
        log.info((Object)("apiId: " + apiId));
        Optional<ApiDescriptor> opt = this.dsManager.getApis(dsId).stream().filter(a -> a.getId().equals(apiId)).map(a -> {
            ApiDescriptor res = new ApiDescriptor();
            res.setBaseUrl(a.getBaseurl());
            res.setId(a.getId());
            res.setProtocol(a.getProtocol());
            res.setCompatibilityLevel(a.getCompatibility());
            res.getParams().put("metadata_identifier_path", a.getMetadataIdentifierPath());
            res.getParams().putAll(a.getApiParams().stream().map(o -> o).collect(Collectors.toMap(ApiParam::getParam, ApiParam::getValue)));
            return res;
        }).findFirst();
        if (opt.isPresent()) {
            Datasource ds = this.dsManager.getDs(dsId);
            Provenance provenance = new Provenance();
            provenance.setDatasourceId(dsId);
            provenance.setDatasourceName(ds.getOfficialname());
            provenance.setNsPrefix(ds.getNamespaceprefix());
            token.getEnv().setAttribute("mdId", this.getMdId());
            token.getEnv().setAttribute("oozieWfPath", this.getOozieWfPath());
            token.getEnv().setAttribute("apiDescription", new Gson().toJson((Object)opt.get()));
            token.getEnv().setAttribute("dataSourceInfo", new Gson().toJson((Object)provenance));
            token.getEnv().setAttribute("workflowId", token.getProcess().getEnv().getAttribute("system:processId"));
            token.getEnv().setAttribute("hdfsValidationAlertsDir", this.hdfsValidationAlertsDir);
            token.getEnv().setAttribute("validationAlertsIndexName", this.validationAlertsIndexName);
            token.getEnv().setAttribute("validationAlertsIndexHost", this.validationAlertsIndexHost);
            token.getEnv().setAttribute("brokerApiBaseUrl", this.brokerBaseUrl);
            if (StringUtils.isNotBlank((CharSequence)this.overrideSubscribers)) {
                token.getEnv().setAttribute("subscribers", this.overrideSubscribers);
            } else {
                token.getEnv().setAttribute("subscribers", ds.getRegisteredby());
            }
            return Arc.DEFAULT_ARC;
        }
        throw new DsmNotFoundException("cannot find ds interface: " + apiId);
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getOozieWfPath() {
        return this.oozieWfPath;
    }

    public void setOozieWfPath(String oozieWfPath) {
        this.oozieWfPath = oozieWfPath;
    }

    public String getHdfsValidationAlertsDir() {
        return this.hdfsValidationAlertsDir;
    }

    public void setHdfsValidationAlertsDir(String hdfsValidationAlertsDir) {
        this.hdfsValidationAlertsDir = hdfsValidationAlertsDir;
    }

    public String getValidationAlertsIndexName() {
        return this.validationAlertsIndexName;
    }

    public void setValidationAlertsIndexName(String validationAlertsIndexName) {
        this.validationAlertsIndexName = validationAlertsIndexName;
    }

    public String getValidationAlertsIndexHost() {
        return this.validationAlertsIndexHost;
    }

    public void setValidationAlertsIndexHost(String validationAlertsIndexHost) {
        this.validationAlertsIndexHost = validationAlertsIndexHost;
    }

    public String getOverrideSubscribers() {
        return this.overrideSubscribers;
    }

    public void setOverrideSubscribers(String overrideSubscribers) {
        this.overrideSubscribers = overrideSubscribers;
    }
}

