/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.controllers;

import eu.dnetlib.dnetrolemanagement.entities.Result;
import eu.dnetlib.dnetrolemanagement.entities.User;
import eu.dnetlib.dnetrolemanagement.services.RoleService;
import eu.dnetlib.dnetrolemanagement.utils.AuthoritiesUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/curator"})
public class CuratorController {
    private final RoleService service;

    @Autowired
    public CuratorController(RoleService service) {
        this.service = service;
    }

    @RequestMapping(value={"/{type:.+}/create"}, method={RequestMethod.POST})
    public ResponseEntity<Result> createRole(@PathVariable(value="type") String type, @RequestParam(value="description", required=false) String description) {
        return ResponseEntity.ok((Object)this.service.createRole(AuthoritiesUtils.group((String)type), description));
    }

    @RequestMapping(value={"/{type:.+}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Result> deleteGroup(@PathVariable(value="type") String type) {
        return ResponseEntity.ok((Object)this.service.deleteRole(AuthoritiesUtils.group((String)type)));
    }

    @RequestMapping(value={"/{type:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<User[]> getAll(@PathVariable(value="type") String type, @RequestParam(value="email", required=false, defaultValue="true") boolean email, @RequestParam(value="name", required=false, defaultValue="true") boolean name) {
        return ResponseEntity.ok((Object)this.service.getUsers(AuthoritiesUtils.group((String)type), false, email, name));
    }

    @RequestMapping(value={"/{type:.+}"}, method={RequestMethod.POST})
    public ResponseEntity<Result> assignRole(@PathVariable(value="type") String type, @RequestParam(value="identifier", required=false) String identifier, @RequestParam(value="email", required=false) String email, @RequestParam(value="force", defaultValue="false") boolean force) {
        return ResponseEntity.ok((Object)this.service.assignRole(AuthoritiesUtils.group((String)type), identifier, email, force, AuthoritiesUtils.curator((String)type)));
    }

    @RequestMapping(value={"/{type:.+}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Result> removeRole(@PathVariable(value="type") String type, @RequestParam(value="identifier", required=false) String identifier, @RequestParam(value="email", required=false) String email) {
        return ResponseEntity.ok((Object)this.service.removeRole(AuthoritiesUtils.group((String)type), identifier, email, AuthoritiesUtils.curator((String)type), null));
    }
}

