/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.scripts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import eu.dnetlib.dnetrolemanagement.scripts.TypeManagersExport;
import eu.dnetlib.dnetrolemanagement.services.RegistryService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"irish"})
public class Irish
implements CommandLineRunner {
    @Autowired
    RegistryService registryService;
    private static String TYPE;

    public void run(String ... args) {
        if (args.length > 0) {
            TYPE = args[0];
        }
        ArrayList haveRole = new ArrayList();
        ArrayList haveManagers = new ArrayList();
        List alias = TYPE.contains("institution") ? TypeManagersExport.ORGANIZATIONS : TypeManagersExport.FUNDERS;
        File file = new File(TYPE + ".json");
        File managers = new File(TYPE + "-managers.json");
        JsonArray cous = this.registryService.getCous(TYPE + ".");
        cous.forEach(cou -> {
            String entity = cou.getAsJsonObject().get("Name").getAsString().replace(TYPE + ".", "");
            if (alias.stream().anyMatch(rpo -> rpo.equals(entity))) {
                if (!this.registryService.getUserEmailByCouId(Integer.valueOf(cou.getAsJsonObject().get("Id").getAsInt()), true).isEmpty()) {
                    haveManagers.add(entity);
                }
                haveRole.add(entity);
            }
        });
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.writeValue(file, haveRole);
            objectMapper.writeValue(managers, haveManagers);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

