/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.services;

import eu.dnetlib.dnetrolemanagement.services.AuthoritiesUpdateService;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.stereotype.Service;

@Service
public class AuthoritiesUpdateService
extends HttpSessionSecurityContextRepository {
    private final Logger logger = LogManager.getLogger(AuthoritiesUpdateService.class);
    private final RedisIndexedSessionRepository sessionRepository;

    @Autowired
    public AuthoritiesUpdateService(RedisIndexedSessionRepository sessionRepository) {
        this.sessionRepository = sessionRepository;
    }

    public void update(String id, Update update) {
        Map sessions = this.sessionRepository.findByPrincipalName(id);
        if (sessions != null) {
            sessions.values().forEach(session -> {
                SecurityContext securityContext;
                Authentication authentication;
                if (!session.isExpired() && (authentication = (securityContext = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT")).getAuthentication()) instanceof OAuth2AuthenticationToken) {
                    OAuth2AuthenticationToken auth2 = (OAuth2AuthenticationToken)authentication;
                    securityContext.setAuthentication((Authentication)new OAuth2AuthenticationToken(auth2.getPrincipal(), update.authorities(auth2.getAuthorities()), auth2.getAuthorizedClientRegistrationId()));
                    session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)securityContext);
                }
            });
        }
    }

    public void addRole(String id, GrantedAuthority role) {
        this.update(id, old -> {
            HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>(old);
            authorities.add(role);
            return authorities;
        });
    }

    public void removeRole(String id, GrantedAuthority role) {
        this.update(id, old -> {
            HashSet authorities = new HashSet(old);
            authorities.remove(role);
            return authorities;
        });
    }
}

