/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.scripts;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import eu.dnetlib.dnetrolemanagement.entities.User;
import eu.dnetlib.dnetrolemanagement.scripts.TypeManagersExport;
import eu.dnetlib.dnetrolemanagement.services.RegistryService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Profile(value={"export-managers"})
public class TypeManagersExport
implements CommandLineRunner {
    @Autowired
    RegistryService registryService;
    private final Logger logger = LogManager.getLogger(TypeManagersExport.class);
    private static String TYPE;
    private static final String COMMUNITIES_API = "https://services.openaire.eu/openaire/community/communities";
    public static List<String> ORGANIZATIONS;
    public static List<String> FUNDERS;

    public void run(String ... args) {
        if (args.length > 0) {
            TYPE = args[0];
        }
        RestTemplate restTemplate = new RestTemplate();
        File file = new File(TYPE + "-managers.csv");
        ArrayList managers = new ArrayList();
        JsonArray cous = this.registryService.getCous(TYPE + ".");
        List<String> ids = TYPE.equals("community") ? Arrays.stream((Community[])new Gson().fromJson((String)restTemplate.getForEntity(COMMUNITIES_API, String.class, new Object[0]).getBody(), Community[].class)).map(Community::getId).toList() : (TYPE.contains("institution") ? ORGANIZATIONS : FUNDERS);
        cous.forEach(cou -> {
            String entity = cou.getAsJsonObject().get("Name").getAsString().replace(TYPE + ".", "");
            if (ids.stream().anyMatch(id -> id.equals(entity))) {
                User[] emails;
                Integer couId = cou.getAsJsonObject().get("Id").getAsInt();
                for (User email : emails = (User[])new Gson().fromJson((JsonElement)this.registryService.getUserEmailByCouId(couId, true), User[].class)) {
                    managers.add(new Manager(entity, email.getEmail()));
                }
            }
        });
        try (PrintWriter pw = new PrintWriter(file);){
            pw.println(TYPE + ",email");
            managers.stream().map(Manager::toCSV).forEach(pw::println);
            this.logger.info("Export has been finished");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    static {
        ORGANIZATIONS = Arrays.asList("default-rpo", "marine-institute", "iph", "mary-immaculate-college", "technological-university-dublin", "nda", "ucc", "irel", "i-form-advanced-manufacturing-research-centre", "tusla---child-and-family-agency", "heanet", "maynooth", "met-eireann", "ucd", "ul", "atu", "dublin", "rcsi", "tcd", "setu", "department-of-agriculture-food-and-the-marine", "health-service-executive", "galway", "sport-ireland", "hib", "sfi", "seai", "esri1", "cit", "department-of-children-and-youth-affairs", "dcu", "rotunda-hospital", "deptecc", "mmuh", "dbs", "kpmg", "abbvie-ireland", "kerry-group-ireland", "energy-solutions", "temple-street-children-s-hospital-school", "free-university-of-ireland", "esb", "irish-red-cross-society", "barnardos-ireland", "exergyn-ireland", "mallinckrodt-ireland", "institute-of-digital-innovation-and-research", "nypro-limited", "dionergy-ltd", "openhydro-group-limited", "amnch", "magnostics-ltd", "laramedia", "bjc", "care-alliance-ireland-ltd", "kastus-technologies-limited", "x-celeprint", "suas-educational-development", "st-josephs-special-school", "betapond-limited", "cell-stress-discoveries-limited", "bridge-interpreting-ireland", "crossing-the-line-ireland", "shanahan-research-group", "epa", "22q11-ireland", "trinity-centre-for-asian-studies-trinity-college-dublin-the-university-of-dublin", "t-e-laboratories-limited", "bon-secours-hospital-cork", "aut-even-hospital", "airfield-estate", "cardinal-health-ireland", "twm", "statwolf", "medfit-proactive-healthcare", "cre", "sanmina-ireland-unlimited-company", "syncrophi-systems-ltd", "silvercloud-ireland", "crc", "gbi", "berand-ireland", "dpei", "nmrc", "midas-ireland", "adama-innovations-limited", "meaningmine-ltd", "zoan-biomed-ltd", "nra", "technology-from-ideas", "sacred-heart-hospital", "integer", "codema-ireland", "isme", "nsc", "fhi", "diania-technologies-ltd", "dtcasm", "perfuze-limited", "dairy-processing-technology-centre", "roscommon-university-hospital", "suh", "school-of-applied-language-and-intercultural-studies-salis-dublin-city-university", "metabol", "lake", "adapt-centre-for-digital-content-technology", "aspect-medical-systems", "national-archives", "ida-ireland", "fota-wildlife-park", "kohinoor-limited", "young-scientist-and-technology-exhibition-company-limited-by-guarantee", "swim-ireland", "ssim", "irish-heart-foundation", "pilot-photonics-ireland", "kildare-education-centre", "cdschc", "hpe", "houses-of-the-oireachtas", "the-irish-times-designated-activitycompany", "portable-medical-technology-limited", "ccan", "erinn-innovation", "ntera-limited", "sublimity", "ipc", "university-college-cork-department-of-computer-science", "mental-health-commission", "epi-light-limited", "q4pr", "ibm-ireland", "pilot", "st-mary-s-college", "insight-sfi-research-centre-for-data-analytics", "endeco-technologies", "bard-ireland", "mercy-university-hospital", "advanced-materials-and-bioengineering-research", "cc", "publicpolicy-ie-ireland", "rcsi-university-of-medicine-and-health-science-rcsi", "chiu", "cystinosis-ireland", "gas-networks-ireland", "centre-for-translation-and-textual-studies-salis-dublin-city-university-dcu", "f6s-ie", "project-arts-centre", "portasol-ireland", "boyne-research-institute", "cervos-limited", "cyntelix", "micananotech-limited", "intel-ireland", "kinia", "heartbeat-trust", "marine-natural-resource-governance-mnrg", "cit-infinite-designated-activity-company", "bioprobe-diagnostics-limited", "ucd-school-of-mathematical-sciences-university-college-dublin", "f-s", "espion-ireland", "irish-home-energy-rating-energy-services-ireland", "imma", "iicn", "critical-path-institute-limited", "newsweaver", "tea", "cardi", "cies", "broadcom-ireland", "avara-pharmaceutical-services-ireland", "creme-global-ireland", "cellix", "identifyher-ltd", "ai", "clew-bay-marine-foru", "x-celeprint-limited", "dublin-city-council", "the-national-digital-research-ltd", "luh", "caredoc", "servusnet-informatics-ireland", "the-alzheimer-society-of-ireland", "analog-devices-ireland", "social-justice-ireland", "abbott-rapid-dx-international-limited", "church-of-ireland-theological-institute", "cps", "department-of-education-and-skills", "ral-ams", "apierian-ltd", "nsilico-life-science", "alkermes", "orbsen-therapeutics-ireland", "halbert-research", "university-hospital-kerry", "rotha", "national-parks-and-wildlife-service", "irecomposites-ireland", "leo-pharma-ireland", "st-columcille-s-hospital", "tmrn", "boston-scientific-ireland-limited", "irc", "institut-neuromyog-ne-unit-de-pysiopathologie-et-g-n-tique-du-neurone-et-du-muscle", "irish-equine-centre", "marino-institute-of-education", "dublinia", "algae-health-ireland", "dar-s-na-gaeltachta", "imi", "icorg", "discovery-programme", "bioplastech-ltd", "mitsui-co-ireland", "esb-networks", "shire-ireland", "accenture-ireland", "allergan", "world-vision-of-ireland", "xeolas-pharmaceuticals-limited", "lero", "school-of-physics-trinity-college-dublin", "arts-council", "norcontel", "restored-hearing-ltd", "department-of-religions-and-theology-confederal-school-of-religions-peace-studie-trinity-college-dublin", "sse-airtricity-ltd", "nsrf", "becton-dickinson-research-centre-ireland-limited", "thea", "techworks-marine-ireland", "eureka", "cellix-ireland", "manor-farm-ireland", "compass-informatics", "ifta", "heritage-council", "wrc", "hrb", "redicare-ireland", "ecofix-limited", "st-john-s-senior-school", "uhvs-ltd-n", "johnson-johnson-ireland", "csd", "baboro", "ervia", "wexford-general-hospital", "irish-neonatal-health-alliance", "horizon-nua-innovation", "roche-ireland", "limerick-city-and-county-council", "ncpe", "mergon-ireland", "atl", "shared-vision-technology-limited", "for-ige", "fgu", "carr-comm", "newswhip-media-limited", "mfc", "vrai", "baboro1", "ibm-ireland-pdl", "nci", "hski", "akara-robotics-limited", "nenagh-hospital", "jazz-pharmaceuticals", "mentor", "department-of-the-taoiseach", "sea-and-sh", "bhp", "pharmaflow-ltd", "solarprint-ireland", "asthma-society-of-ireland", "glen", "creme-software-ltd", "oci", "depuy-ireland", "same", "international-development-ireland-limited", "enbio-ireland", "nbl", "terra-geoserv-ltd", "european-campus-card-association", "codex-discovery-ireland", "blackrock-castle-observatory", "virtual-reality-ireland-media-ltd", "inclusion-ireland", "microsoft-ireland", "thea1", "wdc", "charitable-infirmary", "leopardstown-park-hospital", "mco-ireland", "youth-rise-resources-information-support-and-education", "mpil", "rann-s", "renalytix", "clanwilliam", "ovagen-limited", "nmi", "innopharma", "meath-foundation", "wsm", "echalliance-company-limited-by-guarantee", "ipo", "seagate-ireland", "sligo-county-council", "rhat", "m-m-qualtech-limited", "bon-secours-hospital-dublin", "irish-manufacturing-research-imr", "nokia-ireland-limited", "framework-computer-consultants-limited", "lgma", "cork-city-council", "vhi-healthcare", "smart-wires-europe", "ncbc", "blackstairs-lithium-ltd", "synopsys", "st-dympna-s-hospital", "orbsen-therapeutics-limited", "advanced-technologies-forwarding-atf-company-limited", "portiuncula-hospital", "st-davnet-s-hospital", "opw", "sr-technics-ireland", "crospon-ltd", "ucc-academy-dac", "te-laboratories-ireland", "nowcasting-international-limited", "apc-microbiome-institute", "actionaid-ireland", "aptiv-ireland", "aquatt-ireland", "enable-ireland", "nortonlifelock-ireland", "kite-medical-limited", "discover-stm-publishing-ltd", "amarin-ireland", "nci1", "irish-college-of-general-practitioners", "icorg1", "bord-ospideil-naoimh-sheamuis", "saint-josephs", "atturos", "national-instruments-ireland", "home-instead-senior-care", "glasport-bio-limited", "aisr", "novartis-ireland", "respond-housing-association", "eblana", "irish-heritage-trust", "marigot-ireland", "voysis-ireland", "nuritas-ireland", "custom-compost", "teleflex-ireland", "bentley-systems", "nvp-energy", "g-m-steel-fabricators-limited", "all-hallows-college", "ingersoll-rand-ireland", "havok", "ervia1", "rod", "nogra-pharma-ireland", "element-six-ireland", "centre-of-synthesis-and-chemical-biology-school-of-chemistry-trinity-college-dublin", "an-garda-s-och-na", "horizon-pharma", "bodywhys", "aurigen-medical-limited", "visum", "3d-technology-medscan3d", "forfas", "multiple-sclerosis-society-of-ireland", "dublin-rape-crisis-centre", "gmi", "xilinx-ireland-unlimited-company", "microgen-biotech-ireland", "enterprise-ireland", "fighting-blindness", "alcon-ireland", "kla-ireland", "avectas-limited", "arthritis-ireland", "holfeld-plastics-limited", "ndrc", "proxy-biomedical-limited", "ipposi", "redzinc", "envirotech-innovative-products-ltd", "topchem-pharmaceuticals-limited", "biostor", "the-discovery-programme-centre-for-archaeology-and-innovation-ireland", "galway-city-council", "hc", "columba", "hpsc", "sulzer-ireland", "sbl", "national-council-for-curriculum-and-assessment", "central-bank-of-ireland", "dri", "smart-m-power-company-limited", "the-label-company", "deafhear", "eaton-ireland", "jazz-pharmaceuticals-ireland", "the-irish-farmers-association", "our-lady-s-hospital", "tile-films-ireland", "rds", "o-malley-fisheries", "devenish-research-development-and-innovation", "european-foundation-for-the-improvement-of-living-and-working-conditions", "suite5-data-intelligence-solutions-limited", "pilz-ireland-industrial-automation-distribution", "cook", "era-maptec-ireland", "clrp", "micropro", "ihf", "cso", "dfi", "the-ark", "synthesis-and-solid-state-pharmaceutical-centre", "st-johns-ns", "decawave", "european-health-futures-forum", "irish-bioeconomy-foundation", "inland-fisheries-ireland1", "eli-lilly-s-a-irish-branch", "origin-enterprises-ireland", "communicraft-ltd", "compuscript-ltd", "ti", "kelada-pharmachem-ireland", "epa1", "rveeh", "castolin-eutectic-ireland", "front-line-defenders", "plasmaleap-technologies", "iimc", "slidepath", "fsai", "dod", "composite-recycling-ltd", "st-vincent-s-university-hospital1", "coillte-ireland", "connect-the-dots-events-limited", "intr", "vornia-biomaterials-ireland", "daysha", "government-of-ireland", "anaphylaxi", "pieta-house", "eblana-photonics-ireland", "eolas-ireland", "reprodoc-ireland", "ec", "atxa-therapeutics-ltd", "crospon-ireland", "voyagerip-international-services-limited", "pmd-device-solutions-limited", "concern-worldwide", "national-microelectronics-applications-centre-ireland", "energy-action-lbg", "carr", "r-r", "bord-gais-energy-limited", "byrne-roisin", "bsi-cybersecurity-and-information-resilience", "cork-constraint-computation-centre-university-college-cork", "gec", "ihrb", "clw", "dommrs", "vysera-biomedical-limited", "nokia-ireland", "kinesis-health-technologies-ireland", "eirgrid-ireland", "castlebridge", "st-patrick-s-mental-health-services", "skytek", "ubotica-technologies-limited", "xperi-ireland", "spectrum", "nwwrac", "glen-dimplex-group", "equilume-ireland", "derilinx-limited", "lawler-sustainability", "cies1", "progress-ireland", "ehma", "mpstor-limited", "naval-group-ireland", "cortechs", "solearth-architecture", "monaghan-biosciences-ireland", "glencree", "iafs", "em-path", "st-patrick-s-college", "tsunami", "reamda-ltd", "hsi", "endo-ireland", "ims-maxims-ireland", "royal-society-of-chemistry", "dairygold-co-operative-society-ireland", "slainte-beoga-teoranta", "accuplex-diagnostics", "rockfield-medical-devices-ltd", "irish-research-council-for-science-engineering-and-technology", "sbn", "daithi-o-murchu-marine-research-station", "sigmoid-pharma-ireland", "votechnik", "bmrs", "aquila-bioscience-ireland", "opsona-therapeutics-ireland", "lundin-mining-ireland", "ria", "seol", "bec", "university-college-cork-school-of-biochemistry-and-cell-biology", "helixworks-technologies-limited", "sustainable-innovation-technology-services-limited", "sas-institute-ireland", "mdn", "skytek-ireland", "eirgrid-plc", "etu", "irfu", "saolta-university-health-care-group", "sirus-aircon", "ierc", "irish-country-meats-sheepmeat-unlimited-company", "the-european-coalition-for-people-living-with-obesity-company-limited-by-guarantee", "optrace-ireland", "hydro-international-ireland", "rpii", "the-federation-of-irish-beekeepersassociations", "spark-works-limited", "silvercloud-health-limited", "city-analysts-ltd", "dolmen-design-and-innovation", "ceia", "cuh", "emedia-interactive-limited", "openapp", "eblana1", "adient-ireland", "irish-rail", "kerry-group-plc", "juno-composites-ltd", "ipu", "kinesense-limited", "henkel-ireland", "uisce-eireann", "clean-communications-limited", "national-cancer-registry", "national-maternity-hospital", "kilcreene-orthopaedic-hospital", "biomarin-ireland", "hpra", "mwra", "ndlr", "inlecom-commercial-pathways-companylimited-by-guarantee", "efl", "evercam-io", "neuravi-limited", "irish-institute-of-training-and-development", "ocean-energy-limited", "keywater-fisheries-limited", "cro", "alimentary-glycoscience-research-cluster", "intel-ireland1", "dell-ireland", "rcni", "siriusxt-limited", "galway-clinic", "bh-consulting-ireland", "beal-organic-cheese-limited", "tunstall-ireland", "irc1", "bts", "bioatlantis-ireland", "boardmatch", "blafar-limited", "sivuh", "irish-hydrodata-ireland", "irish-jewish-museum", "tirl-n", "spirasi", "ekf", "bsl", "iccl", "employability-galway", "ichec", "medtronic-ireland", "ctl", "amc", "vornia-limited", "iei", "limerick-county-council", "umhl", "airtel", "irish-college-of-paramedics", "energy-co-operatives-ireland", "talam-biotech-limited", "mincon-ireland", "opera-software-ireland", "beats-medical-limited", "acet", "transpharmation-ireland", "nsilico-ireland", "oran-pre-cast-ireland", "ogt", "infant", "aubren", "java-clinical", "abb", "irish-manufacturing-research", "kingspan-ireland", "schlumberger-ireland", "irish-whale-and-dolphin-group", "childminding-ireland", "business-point-intelligence-solutions-limited", "xilinx-ireland", "st-luke-s-hospital", "forest-environmental-research-and-services-limited", "kfo", "eastern-and-midland-regional-assembly", "circa-group-europe-ireland", "national-children-s-research-centre", "tfri", "icbf", "bell-labs-ireland", "tolerant-networks", "balor-arts-centre", "prophotonix-irl-limited", "nanoscale-function-group-conway-institute-of-biomolecular-and-biomedi-university-college-dublin", "irish-cancer-society", "carare", "ireland-canada-university-foundation", "sigmoid", "juniper-networks-ireland", "comharchumann-fuinnimh-oileain-arann-teoranta", "kildare-and-wicklow-education-and-training-board", "huntington-s-disease-association-of-ireland", "ficontec-ireland-limited", "luxcel", "mayo-general-hospital", "redzinc-ireland", "gocar", "wripl-technologies-limited", "dingle-hub", "ashland-specialties-ireland-limited", "ucd-school-of-mathematics-and-statistics-university-college-dublin", "mount-carmel-hospital", "oncomark-ireland", "boliden-tara-mines-ireland", "con-traas-ltd", "spectrum-instruments-ltd", "project-arts-centre1", "iga", "czs", "tri-ie", "beotanics-limited", "symantec", "science-gallery-international", "health-research-charities-ireland", "memjet-ireland", "red-hat-ireland", "acquired-brain-injury-ireland", "abl", "palliare", "irish-opera-transformations-company-limited-by-guarantee", "hooke-bio-ltd", "guh", "recyclenet-ireland-limited", "entellexi-ireland", "milltown-institute-of-theology-and-philosophy", "f-ilte-ireland", "lit", "iadt", "mmi-clinical-research-development-ireland", "smartbay-ireland", "iec", "ibm-research-ireland", "cct", "global-brain-health-institute", "dawn-meats-group", "tfc-research-and-innovation-limited", "kerry-education-and-training-board", "temple-street-children-s-university-hospital", "peracton", "sports-surgery-clinic-limited", "ogt-amenity-ireland", "city-of-dublin-education-and-training-board", "opn", "iprt", "clg", "danaher-ireland", "atrian-medical-limited", "universal-learning-systems-ltd", "health-information-and-quality-authority", "tel", "mmi", "advance-science-ltd", "infineon-technologies-ireland-limited", "st-luke-s-institute-of-cancer-research", "national-biodiversity-data-centre", "combilift-ireland", "takeda-ireland", "sivuh1", "t-l", "school-of-chemistry-and-chemical-biology-university-college-dublin", "poly-pico-technologies-ltd", "ericsson-ireland", "siren", "mitel-ireland", "hisi", "global-action-plan-ltd", "the-seaweed-company-green-turtle-limited", "vistatec-ltd", "necl", "animal-health-ireland-initiative", "vrm-technology-limited", "icorsa", "ccrt", "the-american-college", "cosmo-pharmaceuticals-ireland", "ovagen-group-limited", "glen-dimplex-heating-ventilation-ireland-unlimited-company", "erp", "epri-europe-dac", "konnecta-systems-limited", "bord-na-m-na-ireland", "cara-pharmacy", "neuromod-ireland", "garda-s-och-na-college", "elan", "sahkartell", "bms", "nui-galway-whitaker-instiute", "saint-john-of-god-hospital", "energy-monitoring-ireland-limited", "family-carers-ireland", "galway-county-council", "icr", "md", "federation-of-irish-beekeepers-associations-fibka-clg", "physical-education-and-sport-sciences-department-university-of-limerick", "croom-precision-tooling-limited", "johnson-controls-ireland", "kci", "wexford-county-council", "stryker-ireland", "iw", "department-of-public-expenditure-and-reform", "department-of-mathematics-national-university-of-ireland-dublin", "sir-patrick-duns-research-laboratory-central-pathology-laboratory-st-james-s-hospital", "monaghan-county-council", "pinpoint-innovations-ltd", "ispca", "abu-international-project-management-limited", "4d-pharma-cork-limited", "mac", "gcc", "monaghan-mushrooms-ireland", "bny-mellon-fund-services-ireland-limited", "accenture-global-solutions", "hea", "saint-john-of-god-hospital-clg", "bard-ireland1", "bantry-general-hospital", "ove-arup-partners-ireland-limited", "techrete-ireland-limited", "valeo-ireland", "vornia-ireland", "endowave-limited", "farran-technology-ireland", "department-of-health", "coillte-teoranta", "cork-county-council", "bernal-institute-university-of-limerick", "apk-architects-engineers-limited", "airmid-healthgroup", "epda", "invizbox-ltd", "supply-network-shannon-ireland", "novus-diagnostics-limited", "janssen-ireland", "cuan-beo-environmental-company-lbg", "david-macleod", "kelloggs", "ibat-college", "rms-limited", "eiwh1", "institute-for-methods-innovation", "fnt", "school-of-politics-international-relations-spire-university-college-dublin", "clare-county-council", "sensl-ireland", "oxymem-ireland", "nokia-ireland1", "ihrec", "ervia-ireland", "pfizer-ireland", "numa", "w1da", "irish-green-building-council-limited-by-guarantee", "reachout-ireland", "innopharma-education", "enerit", "energy-reform", "btsb", "aer-lingus-ireland", "department-of-botany-university-of-dublin", "tcc", "cleverbooks-limited", "department-of-justice", "deparment-of-children-and-youth-affairs-ireland", "bon-secours-hospital-tralee", "xilinx-ireland1", "cook-medical-ireland", "walton-institute-for-information-and-communications-systems-science", "st-patrick-s-hospital", "coney-island-shellfish-limited", "louth-county-council", "beacon-hospital", "depuy-ireland1", "central-mental-hospital", "future-analytics", "blackrock-castle-observatory1", "fitzgerald-nurseries-ireland", "alimentary-health-ireland", "sindice", "greencore-ireland", "apc-ltd", "health-research-institute-university-of-limerick", "abm-europe-bridge-systems", "byrne-looby-phmccarthy", "liquid-technologies", "perrigo-ireland", "klas-telecom", "dias", "escrs", "analog-devices-international", "college-of-medicine-nursing-and-health-sciences-national-university-of-ireland-galway", "mylan-ire-healthcare-limited", "artomatix-limited", "designpro-ltd", "strep", "st-luke-s-general-hospital", "dsc", "itma", "srs", "teilifis-na-gaeilge-tg4", "jjvci", "filmbase", "prothena-ireland", "eisi", "oryx-international-growth-fund-ireland", "the-adelaide-meath-hospital-dublin-incorporating-the-national-children-s-hospital", "innocoll-ireland", "isl", "ryanair-designated-activity-company", "humanities-in-the-european-research-area", "crowdhelix-limited", "parameter-space-ireland", "human-dx", "wood-group-kenny", "alkermes-ireland", "wavebob-ltd", "glaxosmithkline-ireland", "qualia-analytics", "south-dublin-county-council", "brandon-bioscience-ireland", "immigrant-council-of-ireland", "opko-health-ireland", "merlin-park-university-hospital", "rda", "tyndall-national-institute-tni", "space-technology-ireland", "ecosphere-ltd", "biotricity", "burnside", "kerry-county-council", "danu-sports", "anabio-technologies-ireland", "ies-r-d", "perkinelmer-ireland", "arran", "gkinetic-energy-limited", "national-gallery-of-ireland", "mcs", "tsm-control-systems", "the-state-laboratory", "diasorin-ireland", "our-lady-s-hospital-school", "huawei-technologies-ireland-co-limited", "macra-na-feirme", "respect-ltd", "froebel-college-of-education", "stillwater-communications-limited", "irving-oil-whitegate-refinery-limited", "ballyhoura-development-ireland", "st-patrick-s-college-a-college-of-dublin-city-university", "wrh", "circa-group-europe", "dell-ireland1", "wordsworth-learning-limited", "chancel-limited", "the-revenue-commissioners", "brandon-products-ltd", "nsai", "forest-enterprises-limited", "ncbi", "dfi1", "wwp", "nrh", "shire", "connolly-hospital-blanchardstown", "applied-intelligence-analytics", "enerit-limited", "the-royal-society-grant", "valitacell-ltd", "ecological-consultancy-services-ireland", "movidius-ltd", "university-of-dublin-dept-of-mathematics-university-college", "cdetb", "tii", "mhi", "department-of-culture-heritage-and-the-gaeltacht", "surgacoll", "hsa", "eurofins-ireland", "movidius-limited", "vitra", "brennan-company-ireland", "nyci", "teva-pharmaceuticals-ireland", "sjh", "ics-skills", "utrc", "easo", "impedans-ireland", "ollh", "nala", "equal-1-laboratories-ireland-limited", "agilent-technologies-ireland", "nutritics-limited", "clarity-centre-for-sensor-web-technologies", "international-mushrooms-ltd", "cellix-ltd", "the-office-of-public-works", "general-paints-ireland", "creditlogic-limited", "lexisnexis-risk-solutions-europe-ltd", "learning-hub-limerick", "future-analytics-consulting", "university-hospital-limerick", "mdi", "rodis", "early-childhood-ireland", "aerogen", "bii", "orpc-ireland-limited", "rss", "atlantia-food-clinical-trials", "the-soar-foundation", "pai", "konnekt-able-technologies", "hpp", "national-museum-of-ireland-archaeology", "dell-ireland2", "fishing-in-ireland", "midland-regional-hospital-portlaoise", "gorta-self-help-africa-sha", "ican", "ahi", "geneseg", "department-of-justice-and-equality", "oceanfuel-ltd", "department-of-education", "bd", "compuscript", "dkit", "heystaks-technologies-ireland", "rcpi", "iaa-coopans", "dr", "flamel-ireland", "intune-networks-ireland", "cappagh-national-orthopaedic-hospital", "gorta-self-help-africa", "cgh", "rt", "st-finbarr-s-hospital", "ostoform", "microsemi-ireland-trading", "sonas-technologies", "pintail-ireland", "hrb-clinical-research-facility-galway", "access-earth-limited", "covidien", "tasc", "isqua", "rusal-ireland", "nibrt", "t", "kingsbridge-private-hospital-sligo", "red-t", "labas", "plusvital-ireland", "irish-composites-centre", "midland-regional-hospital-mullingar", "c-b-o-c", "department-of-foreign-affairs", "horizon-therapeutics-united-kingdom", "indi", "google-ireland", "tapastreet-limited", "the-post-office", "open-innovation-partners-limited", "endeco-technologies-limited", "tgo", "eli-lilly-ireland", "valeo-vision-systems", "iimc1", "association-for-dental-education-in-europe", "nui-galway-economics", "hyperion-ireland", "social-care-ireland", "celignis-limited", "longline-environment", "kids-speech-labs-limited", "rte", "zutec", "western-vascular-institute-ltd", "tyco-ireland-limited", "irish-learning-technology-association", "liebherr-container-cranes-limited", "iiu", "allergan-ireland", "coombe-women-infants-university-hospital", "code-plus-limited", "irish-life-ireland", "ebay-ireland", "power-capital-renewable-energy-ltd", "st-michael-s-hospital", "dduh", "cork-alliance-centre", "dlrcoco", "fighting-blindness1", "cmp", "convex-electrical-ireland", "schools-of-medicine-and-biochemistry-immunology-trinity-college-dublin", "rml", "dac", "ibec", "department-of-housing-planning-and-local-government", "innovation-zed-ireland", "icdl", "cf", "childhood-development-initiative-clg", "vox-power", "stgh", "childhood-development-initiative", "gl-r", "accountancy-amp-business-college-ireland-limited-trading-as-dublin-business-school", "recordati-ireland", "shannon-coiled-springs-limited", "national-botanic-gardens-of-ireland", "hpsc1", "shinawil-ireland", "carlow-emergency-doctors-on-call-company-limited-by-guarantee", "cybercolloids", "aiihpc", "haunted-planet-studios-ltd", "shannon-applied-biotechnology-centre", "episensor-ltd", "electro-automation-ireland", "supernode-limited", "pavee-point", "crest", "trustwater", "transport-infrastructure-ireland", "jfmr", "altratech-limited", "local-enterprise-office-cork-north-west", "gdg", "inc", "captec-ireland", "kokomo", "beaumont-hospital", "comhar-teoranta", "banagher-precast-concrete-limited", "space-engagers", "ja", "nemysis", "bioclin-ireland", "animated-language-learning", "wild-atlantic-shellfish-limited", "brepco-bioharma", "eiwh2", "our-lady-s-hospice-ltd", "bausch-health-ireland", "bere-island-projects-group", "renishaw-ireland", "eachtra-archaeological-projects-limited", "vision-built-structures-ltd", "enbio-limited", "causewaycs", "nt-mdt-s-l", "children-s-health-ireland", "plc-ingredients-limited", "childvision", "biosensia-ireland", "nexus-research", "vistamed-ireland", "co", "goal", "the-irish-association-for-applied-linguistics", "decare-dental-ireland-limited", "vitalograph-ireland", "irish-sea-fisheries-board", "imma1", "westbic", "reagecon-ireland", "nesc", "biopixs", "solanotech-ireland", "pfizer-healthcare-ireland", "marino-school", "fotonation", "department-of-foreign-affairs-and-trade", "polypico", "mayo-county-council", "irish-diagnostic-laboratory-services-limited", "mgh", "seqome-limited", "ipsen-ireland", "trinity-college-dublin-department-of-geology", "tsm-control-systems1", "the-institution-of-engineers-of-ireland", "state-laboratory", "our-lady-s-children-s-hospital", "seedtech", "iet", "origin", "cdamc", "ds-biopharma-ireland", "bon-secours-hospital-galway", "abbott-ireland", "alcatel-lucent-ireland-limited", "geological-survey-of-ireland", "brandtone-ireland", "alltech-ireland", "st-nicholas-trust", "thinksmart-technologies-ltd", "national-platform-of-self-advocates", "davis-college", "sensl", "breakthrough-cancer-research", "ictu", "truly-irish-country-food-limited", "dfla", "st-paul-s-ns", "radisens-diagnostics-limited", "esb-innovation-roi-limited", "newpark-music-centre", "diageo-ireland", "college-of-engineering-and-informatics-national-university-of-ireland-galway", "molloy-environmental-systems-ireland", "move", "numerics-warehouse-ltd", "teagasc-the-irish-agriculture-and-food-development-authority", "icon", "vivasure-medical", "smebd", "firecomms", "deciphex-limited", "icep-europe-the-institute-of-child-education-and-psychology-europe", "riai", "iscp", "teni", "engineering-solutions-international-ireland", "remedy-biologics-limited", "glanbia-ireland", "focus-ireland", "irish-co-operative-organisation-society-limited", "beocare-limited", "st-johns-hospital", "ssc", "eisi1", "irb", "british-council", "slr-consulting-ireland", "coady-partnership-architects-limited", "vetex-medical-limited", "shellfish-ireland-ireland", "epilepsy-ireland", "ecowellness-consulting-limited", "cylon-controls-limited", "oran-pre-cast-limited", "midland-regional-hospital-at-tullamore", "q4-public-relations", "galway-clinic-doughiska", "department-of-health1", "xeolas-pharmaceuticals-ireland", "randox-teoranta", "crosscare-limited", "atlantic-shellfish-ltd", "cope-galway", "perch-dynamic-solutions-limited", "the-institution-of-engineering-and-technology", "marine-law-and-ocean-policy-research-services-ltd", "michael", "creganna", "its");
        FUNDERS = Arrays.asList("default-rfo", "health-research-board3", "university-of-limerick4", "shell-e-and-p-ireland2", "arts-and-disability-ireland2", "lauritzson-foundation2", "moore-institute-for-research-in-the-humanities-and-social-studies-university-of-galway2", "irish-heart-foundation3", "alimentary-glycoscience-research-cluster2", "centre-for-ageing-research-and-development-in-ireland1", "national-university-of-ireland-maynooth2", "collaborative-centre-for-applied-nanotechnology1", "energy-policy-research-centre-economic-and-social-research-institute2", "irish-college-of-general-practitioners2", "enterprise-ireland7", "irish-association-for-cancer-research2", "breast-cancer-ireland2", "irish-thoracic-society1", "cork-institute-of-technology2", "bernal-institute-university-of-limerick2", "economic-and-social-research-institute2", "synthesis-and-solid-state-pharmaceutical-centre2", "irish-youth-justice-service1", "national-children's-research-centre1", "dormant-accounts-fund2", "heritage-council3", "irish-hospice-foundation1", "national-parks-and-wildlife-service2", "irish-research-elibrary2", "sport-ireland-institute2", "heystaks-technologies1", "amarin-corporation2", "tyndall-national-institute3", "cystic-fibrosis-ireland1", "cystinosis-ireland3", "iris-o'brien-foundation2", "institute-of-technology-tralee1", "royal-college-of-surgeons-in-ireland6", "research-and-education-foundation-sligo-general-hospital2", "simon-cumbers-media-fund2", "department-of-the-environment-climate-and-communications2", "st-luke's-institute-of-cancer-research2", "epilepsy-ireland3", "irish-motor-neurone-disease-association2", "bausch-and-lomb-ireland2", "national-council-for-forest-research-and-development2", "irish-mps-society2", "irish-research-council3", "irish-endocrine-society2", "ireland-funds2", "department-of-tourism-culture-arts-gaeltacht-sport-and-media1", "irish-cancer-society4", "elan2", "environmental-protection-agency1", "st-vincents-anaesthesia-foundation2", "our-lady's-children's-hospital-crumlin1", "jazz-pharmaceuticals2", "ida-ireland4", "filmbase2", "department-of-communications-energy-and-natural-resources-ireland2", "advanced-materials-and-bioengineering-research2", "irish-composites-centre2", "health-research-institute-university-of-limerick2", "irish-rugby-football-union1", "precisionbiotics-group2", "athlone-institute-of-technology1", "paralympics-ireland2", "shire2", "department-of-jobs-enterprise-and-innovation1", "irish-centre-for-high-end-computing1", "horizon-therapeutics2", "sustainable-energy-authority-of-ireland1", "trinity-college-dublin9", "munster-technological-university3", "mental-health-commission3", "dystonia-ireland2", "dublin-city-university3", "adapt---centre-for-digital-content-technology2", "ireland-canada-university-foundation2", "an-roinn-sl\u00e1inte1", "dublin-institute-for-advanced-studies5", "perrigo-company-charitable-foundation2", "glen2", "dublin-city-council4", "humanities-in-the-european-research-area2", "college-of-medicine-nursing-and-health-sciences-national-university-of-ireland-galway2", "breakthrough-cancer-research2", "global-brain-health-institute2", "alkermes2", "college-of-engineering-and-informatics-national-university-of-ireland-galway2", "irish-institute-of-clinical-neuroscience1", "irish-aid2", "physical-education-and-sport-sciences-department-university-of-limerick2", "ucd-foundation2", "department-of-education-and-skills-ireland2", "society-for-musicology-in-ireland2", "pfizer-healthcare-ireland2", "deparment-of-children-and-youth-affairs-ireland2", "royal-dublin-society1", "technological-university-dublin4", "meath-foundation3", "friedreich\u2019s-ataxia-research-alliance-ireland2", "university-of-galway3", "irish-nephrology-society2", "raidi\u00f3-teilif\u00eds-\u00e9ireann1", "covidien2", "brennan-and-company2", "national-cancer-registry-ireland1", "apc-microbiome-institute3", "arts-council-of-ireland1", "food-institutional-research-measure2", "dairy-research-ireland2", "transport-infrastructure-ireland3", "department-of-foreign-affairs-and-trade-ireland1", "royal-college-of-physicians-of-ireland1", "galway-university-foundation2", "alimentary-health1", "marine-institute9", "university-college-cork5", "teagasc7", "higher-education-authority6", "royal-irish-academy2", "central-remedial-clinic3", "inland-fisheries-ireland4", "clarity-centre-for-sensor-web-technologies3", "parkinson's-association-of-ireland1", "allergan2", "geological-survey-of-ireland4", "x-bolt-orthopaedics2", "endo-international2", "department-of-agriculture-food-and-the-marine-ireland1", "european-society-of-cataract-and-refractive-surgeons1", "fotonation4", "dairy-processing-technology-centre2", "food-safety-authority-of-ireland1", "waterford-institute-of-technology1", "health-research-charities-ireland2", "insight-sfi-research-centre-for-data-analytics3", "health-service-executive3", "gaelic-athletic-association1", "university-college-dublin5", "nabriva-therapeutics2", "irish-phytochemical-food-network2", "sfi_rfo");
    }
}

