/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.services;

import com.google.gson.JsonArray;
import eu.dnetlib.dnetrolemanagement.entities.Result;
import eu.dnetlib.dnetrolemanagement.entities.User;
import eu.dnetlib.dnetrolemanagement.services.AuthoritiesUpdateService;
import eu.dnetlib.dnetrolemanagement.services.RegistryService;
import eu.dnetlib.dnetrolemanagement.utils.JsonUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.UnprocessableException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class AdminService {
    private final RegistryService registryService;
    private final AuthoritiesUpdateService authoritiesUpdater;
    private final JsonUtils jsonUtils;

    @Autowired
    public AdminService(RegistryService registryService, AuthoritiesUpdateService authoritiesUpdater, JsonUtils jsonUtils) {
        this.registryService = registryService;
        this.authoritiesUpdater = authoritiesUpdater;
        this.jsonUtils = jsonUtils;
    }

    public User[] getUsers(String role, boolean email, boolean name) {
        Integer couId = this.registryService.getCouId(role);
        if (couId != null) {
            JsonArray users = this.registryService.getUserIdByCouId(couId, true);
            JsonArray emails = email ? this.registryService.getUserEmailByCouId(couId, true) : new JsonArray();
            JsonArray names = name ? this.registryService.getUserNamesByCouId(couId, true) : new JsonArray();
            return this.jsonUtils.mergeUserInfo(users, emails, names);
        }
        throw new NotFoundException(role + ": Role has not been found");
    }

    public Result assignRole(String role, String identifier, String email, String authority, String adminAuthority) {
        List coPersonIds = this.registryService.getCoPersonIdsByEmail(email, identifier);
        if (!coPersonIds.isEmpty()) {
            Integer temp = this.registryService.getCouId(role);
            if (temp != null || authority != null) {
                Integer couId = temp != null ? temp : this.registryService.createRole(role, "");
                AtomicBoolean assigned = new AtomicBoolean(false);
                coPersonIds.forEach(coPersonId -> {
                    if (this.assignRoleToAccount(coPersonId, couId, authority, adminAuthority)) {
                        assigned.set(true);
                    }
                });
                if (assigned.get()) {
                    return new Result(adminAuthority, "Role has been assigned successfully");
                }
                throw new UnprocessableException(role + ": User must be a member of this group and not already admin");
            }
            throw new NotFoundException(role + ": Role has not been found");
        }
        throw new NotFoundException(role + ": User has not been found");
    }

    public Result removeRole(String role, String identifier, String email, String adminAuthority) {
        List coPersonIds = this.registryService.getCoPersonIdsByEmail(email, identifier);
        if (!coPersonIds.isEmpty()) {
            Integer couId = this.registryService.getCouId(role);
            if (couId != null) {
                coPersonIds.forEach(coPersonId -> {
                    this.registryService.removeAdminRole(coPersonId, couId);
                    this.authoritiesUpdater.removeRole(this.registryService.getIdentifierByCoPersonId(coPersonId), (GrantedAuthority)new SimpleGrantedAuthority(adminAuthority));
                });
                return new Result(adminAuthority, "Role has been revoked successfully");
            }
            throw new NotFoundException(role + ": Role has not been found");
        }
        throw new NotFoundException(role + ": User has not been found");
    }

    private boolean assignRoleToAccount(Integer coPersonId, Integer couId, String authority, String adminAuthority) {
        String identifier = this.registryService.getIdentifierByCoPersonId(coPersonId);
        Integer roleId = this.registryService.getRoleId(coPersonId, couId);
        if (roleId != null || authority != null) {
            if (roleId == null) {
                this.registryService.assignMemberRole(coPersonId, couId);
                this.authoritiesUpdater.addRole(identifier, (GrantedAuthority)new SimpleGrantedAuthority(authority));
            }
            if (this.registryService.getUserAdminGroup(coPersonId, couId) == null) {
                this.registryService.assignAdminRole(coPersonId, couId);
                this.authoritiesUpdater.addRole(identifier, (GrantedAuthority)new SimpleGrantedAuthority(adminAuthority));
                return true;
            }
            return false;
        }
        return false;
    }
}

