/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.services;

import com.google.gson.JsonArray;
import eu.dnetlib.dnetrolemanagement.entities.Result;
import eu.dnetlib.dnetrolemanagement.entities.User;
import eu.dnetlib.dnetrolemanagement.services.AuthoritiesUpdateService;
import eu.dnetlib.dnetrolemanagement.services.RegistryService;
import eu.dnetlib.dnetrolemanagement.utils.JsonUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ConflictException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.UnprocessableException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class RoleService {
    private final RegistryService registryService;
    private final AuthoritiesUpdateService authoritiesUpdater;
    private final JsonUtils jsonUtils;

    @Autowired
    public RoleService(RegistryService registryService, AuthoritiesUpdateService authoritiesUpdater, JsonUtils jsonUtils) {
        this.registryService = registryService;
        this.authoritiesUpdater = authoritiesUpdater;
        this.jsonUtils = jsonUtils;
    }

    public Result createRole(String role, String description) {
        try {
            if (this.registryService.getCouId(role) == null) {
                this.registryService.createRole(role, description != null ? description : "");
                return new Result(role, "Role has been created successfully");
            }
            throw new ConflictException(role + ": This role already exists");
        }
        catch (HttpClientErrorException e) {
            throw new ConflictException(role + ": This role already exists");
        }
    }

    public Result deleteRole(String role) {
        try {
            Integer couId = this.registryService.getCouId(role);
            if (couId != null) {
                this.registryService.deleteRole(couId);
                return new Result(role, "Role has been deleted successfully");
            }
            throw new NotFoundException(role + ": This role doesn't exists");
        }
        catch (HttpClientErrorException e) {
            throw new UnprocessableException(role + ": A user has this role.");
        }
    }

    public List<User> getUsersByEmail(String email) {
        return this.registryService.getCoPersonIdsByEmail(email).stream().map(id -> {
            User user = new User();
            user.setEmail(this.registryService.getUserEmail(id));
            user.setId(this.registryService.getUserId(id));
            user.setName(this.registryService.getUserNames(id));
            return user;
        }).collect(Collectors.toList());
    }

    public User[] getUsers(String role, boolean isManager, boolean email, boolean name) {
        Integer couId = this.registryService.getCouId(role);
        if (couId != null) {
            JsonArray names;
            JsonArray users = this.registryService.getUserIdByCouId(couId, false);
            JsonArray emails = email ? this.registryService.getUserEmailByCouId(couId, false) : new JsonArray();
            JsonArray jsonArray = names = name ? this.registryService.getUserNamesByCouId(couId, false) : new JsonArray();
            if (isManager) {
                JsonArray managers = this.registryService.getUserIdByCouId(couId, true);
                users.getAsJsonArray().forEach(element -> element.getAsJsonObject().addProperty("isManager", Boolean.valueOf(managers.contains(element))));
            }
            return this.jsonUtils.mergeUserInfo(users, emails, names);
        }
        throw new NotFoundException(role + ": Role has not been found");
    }

    public Result assignRole(String role, String identifier, String email, boolean force, String authority) {
        List coPersonIds = this.registryService.getCoPersonIdsByEmail(email, identifier);
        if (!coPersonIds.isEmpty()) {
            Integer temp = this.registryService.getCouId(role);
            if (temp != null || force) {
                Integer couId = temp != null ? temp : this.registryService.createRole(role, "");
                coPersonIds.forEach(coPersonId -> {
                    this.registryService.assignMemberRole(coPersonId, couId);
                    this.authoritiesUpdater.addRole(this.registryService.getIdentifierByCoPersonId(coPersonId), (GrantedAuthority)new SimpleGrantedAuthority(authority));
                });
                return new Result(authority, "Role has been assigned successfully");
            }
            throw new NotFoundException(role + ": Role has not been found");
        }
        throw new NotFoundException(role + ": User has not been found");
    }

    public Result removeRole(String role, String identifier, String email, String authority, String adminAuthority) {
        List coPersonIds = this.registryService.getCoPersonIdsByEmail(email, identifier);
        if (!coPersonIds.isEmpty()) {
            Integer couId = this.registryService.getCouId(role);
            if (couId != null) {
                if (adminAuthority != null || coPersonIds.stream().noneMatch(coPersonId -> this.registryService.getUserAdminGroup(coPersonId, couId) != null)) {
                    coPersonIds.forEach(coPersonId -> {
                        String userIdentifier = this.registryService.getIdentifierByCoPersonId(coPersonId);
                        Integer roleId = this.registryService.getRoleId(coPersonId, couId);
                        if (adminAuthority != null) {
                            this.registryService.removeAdminRole(coPersonId, couId);
                            this.authoritiesUpdater.removeRole(userIdentifier, (GrantedAuthority)new SimpleGrantedAuthority(adminAuthority));
                        }
                        this.registryService.removeMemberRole(coPersonId, couId, roleId);
                        this.authoritiesUpdater.removeRole(userIdentifier, (GrantedAuthority)new SimpleGrantedAuthority(authority));
                    });
                    return new Result(authority, "Role has been revoked successfully");
                }
                throw new UnprocessableException(role + ": Remove admin role first");
            }
            throw new NotFoundException(role + ": Role has not been found");
        }
        throw new NotFoundException(role + ": User has not been found");
    }
}

