/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.scripts;

import eu.dnetlib.dnetrolemanagement.entities.User;
import eu.dnetlib.dnetrolemanagement.services.AdminService;
import eu.dnetlib.dnetrolemanagement.services.RoleService;
import eu.dnetlib.dnetrolemanagement.utils.AuthoritiesUtils;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"copy-users"})
public class CopyUsers
implements CommandLineRunner {
    public static String TYPE = "community";
    public static String FROM = "ni";
    public static String TO = "neuroscience";
    private final AdminService adminService;
    private final RoleService roleService;

    @Autowired
    public CopyUsers(AdminService adminService, RoleService roleService) {
        this.adminService = adminService;
        this.roleService = roleService;
    }

    public void run(String ... args) throws Exception {
        List<String> alreadyUsers = Arrays.stream(this.roleService.getUsers(AuthoritiesUtils.group((String)TYPE, (String)TO), true, true, false)).map(User::getId).toList();
        Arrays.stream(this.roleService.getUsers(AuthoritiesUtils.group((String)TYPE, (String)FROM), true, true, false)).forEach(user -> {
            try {
                if (user.isIsManager().booleanValue()) {
                    this.adminService.assignRole(AuthoritiesUtils.group((String)TYPE, (String)TO), user.getId(), null, AuthoritiesUtils.member((String)TYPE, (String)TO), AuthoritiesUtils.manager((String)TYPE, (String)TO));
                } else if (!alreadyUsers.contains(user.getId())) {
                    this.roleService.assignRole(AuthoritiesUtils.group((String)TYPE, (String)TO), user.getId(), null, true, AuthoritiesUtils.member((String)TYPE, (String)TO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

