/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.controllers;

import eu.dnetlib.dnetrolemanagement.entities.Result;
import eu.dnetlib.dnetrolemanagement.entities.User;
import eu.dnetlib.dnetrolemanagement.services.AdminService;
import eu.dnetlib.dnetrolemanagement.utils.AuthoritiesUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin"})
public class AdminController {
    private final AdminService service;

    @Autowired
    public AdminController(AdminService service) {
        this.service = service;
    }

    @RequestMapping(value={"/{type:.+}/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<User[]> getAll(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestParam(value="email", required=false, defaultValue="true") boolean email, @RequestParam(value="name", required=false, defaultValue="true") boolean name) {
        return ResponseEntity.ok((Object)this.service.getUsers(AuthoritiesUtils.group((String)type, (String)id), email, name));
    }

    @RequestMapping(value={"/{type:.+}/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<Result> assignRole(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestParam(value="email", required=false) String email, @RequestParam(value="identifier", required=false) String identifier, @RequestParam(value="force", defaultValue="false") boolean force) {
        return ResponseEntity.ok((Object)this.service.assignRole(AuthoritiesUtils.group((String)type, (String)id), identifier, email, force ? AuthoritiesUtils.member((String)type, (String)id) : null, AuthoritiesUtils.manager((String)type, (String)id)));
    }

    @RequestMapping(value={"/{type:.+}/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Result> removeRole(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestParam(value="identifier", required=false) String identifier, @RequestParam(value="email", required=false) String email) {
        return ResponseEntity.ok((Object)this.service.removeRole(AuthoritiesUtils.group((String)type, (String)id), identifier, email, AuthoritiesUtils.manager((String)type, (String)id)));
    }
}

