/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.controllers;

import eu.dnetlib.dnetrolemanagement.configuration.GlobalVars;
import eu.dnetlib.dnetrolemanagement.configuration.Properties;
import eu.dnetlib.dnetrolemanagement.configuration.Registry;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HealthController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Registry registry;
    private final GlobalVars globalVars;

    @Autowired
    public HealthController(Properties properties, GlobalVars globalVars) {
        this.registry = properties.getRegistry();
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.registry.getCoid() == null || this.registry.getCoid().isEmpty()) {
            throw new RuntimeException("role-management.registry.coid is  missing!");
        }
        if (this.registry.getIssuer() == null || this.registry.getIssuer().isEmpty()) {
            throw new RuntimeException("role-management.registry.issuer is  missing!");
        }
        if (this.registry.getUser() == null || this.registry.getUser().isEmpty()) {
            throw new RuntimeException("role-management.registry.user is  missing!");
        }
        if (this.registry.getPassword() == null || this.registry.getPassword().isEmpty()) {
            throw new RuntimeException("role-management.registry.password is  missing!");
        }
        if (this.registry.getVersion() == null || this.registry.getVersion().isEmpty()) {
            throw new RuntimeException("role-management.registry.version is  missing!");
        }
    }

    @RequestMapping(value={"", "/"}, method={RequestMethod.GET})
    public String hello() {
        this.log.debug("Hello from role management!");
        return "Hello from Role management!";
    }

    @PreAuthorize(value="hasAnyAuthority('PORTAL_ADMINISTRATOR')")
    @RequestMapping(value={"/configuration"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("role-management.registry.coid", this.registry.getCoid());
        response.put("role-management.registry.issuer", this.registry.getIssuer());
        response.put("role-management.registry.user", this.registry.getUser());
        response.put("role-management.registry.password", this.registry.getPassword());
        response.put("role-management.registry.version", this.registry.getVersion());
        if (eu.dnetlib.uoaauthorizationlibrary.authorization.configuration.GlobalVars.date != null) {
            response.put("Date of deploy", eu.dnetlib.uoaauthorizationlibrary.authorization.configuration.GlobalVars.date.toString());
        }
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return ResponseEntity.ok(response);
    }
}

