/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.controllers;

import eu.dnetlib.dnetrolemanagement.entities.Result;
import eu.dnetlib.dnetrolemanagement.entities.User;
import eu.dnetlib.dnetrolemanagement.services.RoleService;
import eu.dnetlib.dnetrolemanagement.utils.AuthoritiesUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/member"})
public class MemberController {
    private final RoleService service;

    @Autowired
    public MemberController(RoleService service) {
        this.service = service;
    }

    @RequestMapping(value={"/{type:.+}/{id}/create"}, method={RequestMethod.POST})
    public ResponseEntity<Result> createGroup(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestParam(value="description", required=false) String description) {
        return ResponseEntity.ok((Object)this.service.createRole(AuthoritiesUtils.group((String)type, (String)id), description));
    }

    @RequestMapping(value={"/{type:.+}/{id}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Result> deleteGroup(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.service.deleteRole(AuthoritiesUtils.group((String)type, (String)id)));
    }

    @RequestMapping(value={"/{type:.+}/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<User[]> getAll(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestParam(value="isManager", required=false, defaultValue="true") boolean isManager, @RequestParam(value="email", required=false, defaultValue="true") boolean email, @RequestParam(value="name", required=false, defaultValue="true") boolean name) {
        return ResponseEntity.ok((Object)this.service.getUsers(AuthoritiesUtils.group((String)type, (String)id), isManager, email, name));
    }

    @RequestMapping(value={"/{type:.+}/{id}/count"}, method={RequestMethod.GET})
    public ResponseEntity<Integer> getCount(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.service.getUsers(AuthoritiesUtils.group((String)type, (String)id), false, false, false).length);
    }

    @RequestMapping(value={"/{type:.+}/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<Result> assignRole(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestParam(value="identifier", required=false) String identifier, @RequestParam(value="email", required=false) String email, @RequestParam(value="force", defaultValue="false") boolean force) {
        return ResponseEntity.ok((Object)this.service.assignRole(AuthoritiesUtils.group((String)type, (String)id), identifier, email, force, AuthoritiesUtils.member((String)type, (String)id)));
    }

    @RequestMapping(value={"/{type:.+}/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Result> removeRole(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestParam(value="identifier", required=false) String identifier, @RequestParam(value="email", required=false) String email, @RequestParam(value="force", defaultValue="false") boolean force) {
        return ResponseEntity.ok((Object)this.service.removeRole(AuthoritiesUtils.group((String)type, (String)id), identifier, email, AuthoritiesUtils.member((String)type, (String)id), force ? AuthoritiesUtils.manager((String)type, (String)id) : null));
    }
}

