/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.controllers;

import eu.dnetlib.dnetrolemanagement.entities.Result;
import eu.dnetlib.dnetrolemanagement.entities.User;
import eu.dnetlib.dnetrolemanagement.services.RoleService;
import eu.dnetlib.dnetrolemanagement.utils.AuthoritiesUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/super"})
public class SuperAdminController {
    private final RoleService service;

    @Autowired
    public SuperAdminController(RoleService service) {
        this.service = service;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public ResponseEntity<Result> createRole(@RequestParam(value="name") String name, @RequestParam(value="description", required=false) String description) {
        return ResponseEntity.ok((Object)this.service.createRole(name, description));
    }

    @RequestMapping(value={"/assign"}, method={RequestMethod.POST})
    public ResponseEntity<Result> assignRole(@RequestParam(value="email", required=false) String email, @RequestParam(value="identifier", required=false) String identifier, @RequestParam(value="superAdmin", required=false, defaultValue="false") boolean superAdmin) {
        if (superAdmin) {
            return ResponseEntity.ok((Object)this.service.assignRole(AuthoritiesUtils.superAdminRoleGroup(), identifier, email, false, AuthoritiesUtils.SUPER_ADMIN));
        }
        return ResponseEntity.ok((Object)this.service.assignRole(AuthoritiesUtils.portalAdminGroup(), identifier, email, false, AuthoritiesUtils.PORTAL_ADMIN));
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.DELETE})
    public ResponseEntity<Result> removeRole(@RequestParam(value="email", required=false) String email, @RequestParam(value="identifier", required=false) String identifier, @RequestParam(value="superAdmin", required=false, defaultValue="false") boolean superAdmin) {
        if (superAdmin) {
            return ResponseEntity.ok((Object)this.service.removeRole(AuthoritiesUtils.superAdminRoleGroup(), identifier, email, AuthoritiesUtils.SUPER_ADMIN, null));
        }
        return ResponseEntity.ok((Object)this.service.removeRole(AuthoritiesUtils.portalAdminGroup(), identifier, email, AuthoritiesUtils.PORTAL_ADMIN, null));
    }

    @RequestMapping(value={"/user"}, method={RequestMethod.GET})
    public ResponseEntity<List<User>> getUsersByEmail(@RequestParam(value="email") String email) {
        return ResponseEntity.ok((Object)this.service.getUsersByEmail(email));
    }
}

