/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.scripts;

import eu.dnetlib.dnetrolemanagement.controllers.CuratorController;
import eu.dnetlib.dnetrolemanagement.entities.User;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"monitor-curator"})
public class AssignMonitorCurator
implements CommandLineRunner {
    @Autowired
    CuratorController curatorController;

    public void run(String ... args) throws Exception {
        List<String> types = Arrays.asList("funder", "community", "institution", "project");
        List monitorCurators = Arrays.stream(Objects.requireNonNull((User[])this.curatorController.getAll("monitor", true, false).getBody())).collect(Collectors.toList());
        types.forEach(type -> {
            User[] users = (User[])this.curatorController.getAll(type, true, false).getBody();
            assert (users != null);
            Arrays.stream(users).forEach(user -> {
                if (monitorCurators.stream().noneMatch(curator -> curator.getEmail().equals(user.getEmail()))) {
                    this.curatorController.assignRole("monitor", user.getId(), user.getEmail(), true);
                    System.out.println("Assigned to " + user.getEmail());
                    monitorCurators.add(user);
                }
            });
        });
    }
}

