/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.dnetrolemanagement.utils.HttpUtils;
import eu.dnetlib.dnetrolemanagement.utils.JsonUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegistryService {
    private static final Logger logger = LogManager.getLogger(RegistryService.class);
    private final HttpUtils httpUtils;
    private final JsonUtils jsonUtils;
    private final AuthorizationService authorizationService;

    @Autowired
    public RegistryService(HttpUtils httpUtils, JsonUtils jsonUtils, AuthorizationService authorizationService) {
        this.httpUtils = httpUtils;
        this.jsonUtils = jsonUtils;
        this.authorizationService = authorizationService;
    }

    public List<Integer> getCoPersonIdsByEmail(String email, String identifier) {
        if (email != null) {
            ArrayList<Integer> coPersonIds = new ArrayList<Integer>();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("mail", email);
            JsonElement response = this.httpUtils.get("co_people.json", params);
            if (response != null) {
                JsonArray coPeople = response.getAsJsonObject().get("CoPeople").getAsJsonArray();
                for (int i = 0; i < coPeople.size(); ++i) {
                    coPersonIds.add(coPeople.get(i).getAsJsonObject().get("Id").getAsInt());
                }
            }
            return coPersonIds;
        }
        Integer coPersonId = identifier != null ? this.getCoPersonIdByIdentifier(identifier) : this.getCoPersonIdByIdentifier();
        return coPersonId != null ? Collections.singletonList(coPersonId) : new ArrayList<Integer>();
    }

    public List<Integer> getCoPersonIdsByEmail(String email) {
        return this.getCoPersonIdsByEmail(email, null);
    }

    public Integer getCoPersonIdByIdentifier() {
        try {
            return this.getCoPersonIdByIdentifier(this.authorizationService.getAaiId());
        }
        catch (Exception e) {
            logger.error("Get User info: An error occurred ", (Throwable)e);
            return null;
        }
    }

    public Integer getCoPersonIdByIdentifier(String sub) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search.identifier", sub);
        JsonElement response = this.httpUtils.get("co_people.json", params);
        return response != null ? Integer.valueOf(response.getAsJsonObject().get("CoPeople").getAsJsonArray().get(0).getAsJsonObject().get("Id").getAsInt()) : null;
    }

    public String getIdentifierByCoPersonId(Integer coPersonId) {
        JsonArray ids;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("copersonid", coPersonId.toString());
        JsonElement response = this.httpUtils.get("identifiers.json", params);
        JsonArray jsonArray = ids = response != null ? response.getAsJsonObject().get("Identifiers").getAsJsonArray() : new JsonArray();
        if (!ids.isEmpty()) {
            return ids.get(0).getAsJsonObject().get("Identifier").getAsString();
        }
        return null;
    }

    public JsonArray getCous(String name) {
        JsonElement response;
        HashMap<String, String> params = new HashMap<String, String>();
        if (name != null) {
            params.put("name", name.toLowerCase());
        }
        return (response = this.httpUtils.get("cous.json", params)) != null ? response.getAsJsonObject().get("Cous").getAsJsonArray() : new JsonArray();
    }

    public JsonArray getCous() {
        return this.getCous(null);
    }

    public Integer getCouId(String name) {
        JsonArray cous = this.getCous(name);
        for (JsonElement cou : cous) {
            if (!cou.getAsJsonObject().get("Name").getAsString().equalsIgnoreCase(name)) continue;
            return cou.getAsJsonObject().get("Id").getAsInt();
        }
        return null;
    }

    public JsonArray getRoles(Integer coPersonId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("copersonid", coPersonId.toString());
        JsonElement response = this.httpUtils.get("co_person_roles.json", params);
        return response != null ? response.getAsJsonObject().get("CoPersonRoles").getAsJsonArray() : new JsonArray();
    }

    public Integer getRoleId(Integer coPersonId, Integer couId) {
        JsonArray roles = this.getRoles(coPersonId);
        for (JsonElement role : roles) {
            JsonObject object = role.getAsJsonObject();
            if (object.get("CouId").getAsInt() != couId.intValue() || !object.get("Status").getAsString().equals("Active") && !object.get("Status").getAsString().equals("GracePeriod")) continue;
            return object.get("Id").getAsInt();
        }
        return null;
    }

    public JsonArray getUserGroups(Integer coPersonId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("copersonid", coPersonId.toString());
        JsonElement response = this.httpUtils.get("co_groups.json", params);
        return response != null ? response.getAsJsonObject().get("CoGroups").getAsJsonArray() : new JsonArray();
    }

    public JsonObject getUserAdminGroup(Integer coPersonId, Integer couId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("copersonid", coPersonId.toString());
        JsonElement response = this.httpUtils.get("co_groups.json", params);
        JsonArray roles = response != null ? response.getAsJsonObject().get("CoGroups").getAsJsonArray() : new JsonArray();
        for (JsonElement role : roles) {
            JsonObject object = role.getAsJsonObject();
            if (object.get("CouId") == null || object.get("CouId").getAsInt() != couId.intValue() || !object.get("Name").getAsString().contains("admins")) continue;
            return object;
        }
        return null;
    }

    public JsonArray getCouGroups(Integer couId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("couid", couId.toString());
        JsonElement response = this.httpUtils.get("co_groups.json", params);
        return response != null ? response.getAsJsonObject().get("CoGroups").getAsJsonArray() : new JsonArray();
    }

    public JsonObject getCouAdminGroup(Integer couId) {
        JsonArray groups = this.getCouGroups(couId);
        for (JsonElement group : groups) {
            if (!group.getAsJsonObject().get("Name").getAsString().contains("admins")) continue;
            return group.getAsJsonObject();
        }
        return null;
    }

    public JsonArray getGroupMembers(Integer coGroupId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cogroupid", coGroupId.toString());
        JsonElement response = this.httpUtils.get("co_group_members.json", params);
        return response != null ? response.getAsJsonObject().get("CoGroupMembers").getAsJsonArray() : new JsonArray();
    }

    public JsonArray getUserEmailByCouId(Integer couId, boolean admin) {
        JsonElement response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("couid", couId.toString());
        if (admin) {
            params.put("admin", "true");
        }
        JsonArray infos = (response = this.httpUtils.get("email_addresses.json", params)) != null ? response.getAsJsonObject().get("EmailAddresses").getAsJsonArray() : new JsonArray();
        JsonArray emails = new JsonArray();
        infos.forEach(info -> {
            JsonObject user = new JsonObject();
            user.addProperty("coPersonId", info.getAsJsonObject().get("Person").getAsJsonObject().get("Id").getAsString());
            user.addProperty("email", info.getAsJsonObject().get("Mail").getAsString());
            user.addProperty("memberSince", info.getAsJsonObject().get("Created").getAsString());
            emails.add((JsonElement)user);
        });
        return emails;
    }

    public JsonArray getUserNamesByCouId(Integer couId, boolean admin) {
        JsonElement response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("couid", couId.toString());
        if (admin) {
            params.put("admin", "true");
        }
        JsonArray infos = (response = this.httpUtils.get("names.json", params)) != null ? response.getAsJsonObject().get("Names").getAsJsonArray() : new JsonArray();
        JsonArray names = new JsonArray();
        infos.forEach(info -> {
            JsonObject user = new JsonObject();
            user.addProperty("coPersonId", info.getAsJsonObject().get("Person").getAsJsonObject().get("Id").getAsString());
            user.addProperty("name", info.getAsJsonObject().get("Given").getAsString() + " " + info.getAsJsonObject().get("Family").getAsString());
            user.addProperty("memberSince", info.getAsJsonObject().get("Created").getAsString());
            names.add((JsonElement)user);
        });
        return names;
    }

    public JsonArray getUserIdByCouId(Integer couId, boolean admin) {
        JsonElement response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("couid", couId.toString());
        if (admin) {
            params.put("admin", "true");
        }
        JsonArray infos = (response = this.httpUtils.get("identifiers.json", params)) != null ? response.getAsJsonObject().get("Identifiers").getAsJsonArray() : new JsonArray();
        JsonArray ids = new JsonArray();
        infos.forEach(info -> {
            JsonObject user = new JsonObject();
            user.addProperty("coPersonId", info.getAsJsonObject().get("Person").getAsJsonObject().get("Id").getAsString());
            user.addProperty("id", info.getAsJsonObject().get("Identifier").getAsString());
            user.addProperty("memberSince", info.getAsJsonObject().get("Created").getAsString());
            ids.add((JsonElement)user);
        });
        return ids;
    }

    public void assignMemberRole(Integer coPersonId, Integer couId) {
        this.httpUtils.post("co_person_roles.json", this.jsonUtils.coPersonRoles(coPersonId, couId, "Active"));
    }

    public void removeMemberRole(Integer coPersonId, Integer couId, Integer id) {
        if (id != null) {
            this.httpUtils.put("co_person_roles/" + id + ".json", this.jsonUtils.coPersonRoles(coPersonId, couId, "Deleted"));
        }
    }

    public Integer createRole(String name, String description) {
        JsonElement element = this.httpUtils.post("cous.json", this.jsonUtils.createNewCou(name, description));
        return element.getAsJsonObject().get("Id").getAsInt();
    }

    public void deleteRole(Integer id) {
        this.httpUtils.delete("cous/" + id + ".json");
    }

    public String getUserEmail(Integer coPersonId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("copersonid", coPersonId.toString());
        JsonElement response = this.httpUtils.get("email_addresses.json", params);
        JsonObject info = response != null ? response.getAsJsonObject().get("EmailAddresses").getAsJsonArray().get(0).getAsJsonObject() : null;
        return info != null ? info.getAsJsonObject().get("Mail").getAsString() : null;
    }

    public String getUserNames(Integer coPersonId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("copersonid", coPersonId.toString());
        JsonElement response = this.httpUtils.get("names.json", params);
        JsonObject info = response != null ? response.getAsJsonObject().get("Names").getAsJsonArray().get(0).getAsJsonObject() : null;
        return info != null ? info.getAsJsonObject().get("Given").getAsString() + " " + info.getAsJsonObject().get("Family").getAsString() : null;
    }

    public String getUserId(Integer coPersonId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("copersonid", coPersonId.toString());
        JsonElement response = this.httpUtils.get("identifiers.json", params);
        JsonObject info = response != null ? response.getAsJsonObject().get("Identifiers").getAsJsonArray().get(0).getAsJsonObject() : null;
        return info != null ? info.getAsJsonObject().get("Identifier").getAsString() : null;
    }

    public void assignAdminRole(Integer coPersonId, Integer couId) {
        JsonObject group = this.getCouAdminGroup(couId);
        if (group != null) {
            this.httpUtils.post("co_group_members.json", this.jsonUtils.coGroupMembers(Integer.valueOf(group.get("Id").getAsInt()), coPersonId, true));
        }
    }

    public void removeAdminRole(Integer coPersonId, Integer couId) {
        JsonObject adminGroup = this.getCouAdminGroup(couId);
        JsonArray admins = this.getGroupMembers(Integer.valueOf(adminGroup.get("Id").getAsInt()));
        Integer id = null;
        for (JsonElement admin : admins) {
            if (admin.getAsJsonObject().get("Person").getAsJsonObject().get("Id").getAsInt() != coPersonId.intValue()) continue;
            id = admin.getAsJsonObject().get("Id").getAsInt();
        }
        if (id != null) {
            this.httpUtils.delete("co_group_members/" + id + ".json");
        }
    }
}

