/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dnetrolemanagement.configuration.Properties;
import eu.dnetlib.dnetrolemanagement.configuration.Registry;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpUtils {
    private final Registry registry;

    @Autowired
    public HttpUtils(Properties properties) {
        this.registry = properties.getRegistry();
    }

    public JsonElement post(String path, JsonObject body) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = this.createHeaders(this.registry.getUser(), this.registry.getPassword());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)body.toString(), (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(this.registry.getIssuer() + path, HttpMethod.POST, request, String.class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
            return JsonParser.parseString((String)((String)responseEntity.getBody()));
        }
        return null;
    }

    public void put(String path, JsonObject body) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = this.createHeaders(this.registry.getUser(), this.registry.getPassword());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)body.toString(), (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(this.registry.getIssuer() + path, HttpMethod.PUT, request, String.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            JsonParser.parseString((String)((String)responseEntity.getBody()));
        }
    }

    public JsonElement get(String path, Map<String, String> params) {
        RestTemplate restTemplate = new RestTemplate();
        String url = this.registry.getIssuer() + path + this.createParams(this.addCoId(params));
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.createHeaders(this.registry.getUser(), this.registry.getPassword())), String.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            return JsonParser.parseString((String)((String)responseEntity.getBody()));
        }
        return null;
    }

    public void delete(String path) {
        RestTemplate restTemplate = new RestTemplate();
        String url = this.registry.getIssuer() + path;
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.DELETE, new HttpEntity((MultiValueMap)this.createHeaders(this.registry.getUser(), this.registry.getPassword())), String.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            JsonParser.parseString((String)((String)responseEntity.getBody()));
        }
    }

    private Map<String, String> addCoId(Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("coid", this.registry.getCoid());
        return params;
    }

    private String createParams(Map<String, String> params) {
        StringBuilder ret = new StringBuilder("?");
        int count = 0;
        for (Map.Entry<String, String> param : params.entrySet()) {
            ret.append(param.getKey()).append("=");
            ret.append(param.getValue());
            if (++count == params.entrySet().size()) continue;
            ret.append("&");
        }
        return ret.toString();
    }

    private HttpHeaders createHeaders(String username, String password) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

