/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetrolemanagement.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.dnetrolemanagement.configuration.Properties;
import eu.dnetlib.dnetrolemanagement.entities.User;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JsonUtils {
    private final String version;
    private final String coid;
    private final Gson gson = new Gson();

    @Autowired
    public JsonUtils(Properties properties) {
        this.version = properties.getRegistry().getVersion();
        this.coid = properties.getRegistry().getCoid();
    }

    public User[] mergeUserInfo(JsonArray users, JsonArray emails, JsonArray names) {
        User[] usersMapped = (User[])this.gson.fromJson((JsonElement)users, User[].class);
        User[] emailsMapped = (User[])this.gson.fromJson((JsonElement)emails, User[].class);
        User[] namesMapped = (User[])this.gson.fromJson((JsonElement)names, User[].class);
        for (User user : usersMapped) {
            Optional<User> emailUser = Arrays.stream(emailsMapped).filter(email -> user.getCoPersonId().equals(email.getCoPersonId())).findFirst();
            Optional<User> nameUser = Arrays.stream(namesMapped).filter(name -> user.getCoPersonId().equals(name.getCoPersonId())).findFirst();
            emailUser.ifPresent(value -> user.setEmail(value.getEmail()));
            nameUser.ifPresent(value -> user.setName(value.getName()));
        }
        return usersMapped;
    }

    public JsonObject coPersonRoles(Integer coPersonId, Integer couId, String status) {
        JsonObject role = new JsonObject();
        JsonArray coPersonRoles = new JsonArray();
        JsonObject coPersonRole = new JsonObject();
        JsonObject person = new JsonObject();
        person.addProperty("Type", "CO");
        person.addProperty("Id", coPersonId.toString());
        coPersonRole.addProperty("Version", this.version);
        coPersonRole.add("Person", (JsonElement)person);
        coPersonRole.addProperty("CouId", couId.toString());
        coPersonRole.addProperty("Affiliation", "member");
        coPersonRole.addProperty("Title", "");
        coPersonRole.addProperty("O", "Openaire");
        coPersonRole.addProperty("Status", status);
        if (status.equals("Active")) {
            coPersonRole.addProperty("ValidFrom", new Date().toString());
        } else {
            coPersonRole.addProperty("ValidThrough", new Date().toString());
        }
        coPersonRoles.add((JsonElement)coPersonRole);
        role.addProperty("RequestType", "CoPersonRoles");
        role.addProperty("Version", this.version);
        role.add("CoPersonRoles", (JsonElement)coPersonRoles);
        return role;
    }

    public JsonObject coGroupMembers(Integer coGroupId, Integer coPersonId, boolean member) {
        JsonObject coGroup = new JsonObject();
        JsonArray coGroupMembers = new JsonArray();
        JsonObject coGroupMember = new JsonObject();
        JsonObject person = new JsonObject();
        person.addProperty("Type", "CO");
        person.addProperty("Id", coPersonId.toString());
        coGroupMember.addProperty("Version", this.version);
        coGroupMember.add("Person", (JsonElement)person);
        coGroupMember.addProperty("CoGroupId", coGroupId.toString());
        coGroupMember.addProperty("Member", Boolean.valueOf(member));
        coGroupMember.addProperty("Owner", Boolean.valueOf(false));
        coGroupMember.addProperty("ValidFrom", "");
        coGroupMember.addProperty("ValidThrough", "");
        coGroupMembers.add((JsonElement)coGroupMember);
        coGroup.addProperty("RequestType", "CoGroupMembers");
        coGroup.addProperty("Version", this.version);
        coGroup.add("CoGroupMembers", (JsonElement)coGroupMembers);
        return coGroup;
    }

    public JsonObject createNewCou(String name, String description) {
        JsonObject cou = new JsonObject();
        JsonArray cous = new JsonArray();
        JsonObject newCou = new JsonObject();
        newCou.addProperty("Version", this.version);
        newCou.addProperty("CoId", this.coid);
        newCou.addProperty("Name", name);
        newCou.addProperty("Description", description);
        cous.add((JsonElement)newCou);
        cou.addProperty("RequestType", "Cous");
        cou.addProperty("Version", this.version);
        cou.add("Cous", (JsonElement)cous);
        return cou;
    }
}

