/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.validation;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SetInfoForValidationJobNode
extends SimpleJobNode {
    public static final Log log = LogFactory.getLog(SetInfoForValidationJobNode.class);
    @Autowired
    private LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager;
    private String profileId;
    private String providerName;
    private String api;

    protected String execute(NodeToken token) throws Exception {
        String dsId = this.getProfileId();
        String nsPrefix = this.dsManager.getDs(dsId).getNamespaceprefix();
        String interfaceURL = this.dsManager.getApis(dsId).stream().filter(a -> a.getId().equals(this.getApi())).map(a -> a.getBaseurl()).findFirst().orElse("");
        token.getEnv().setAttribute("dataprovider:id", dsId);
        token.getEnv().setAttribute("dataprovider:originalid", dsId);
        token.getEnv().setAttribute("dataprovider:name", this.getProviderName());
        token.getEnv().setAttribute("dataprovider:interface", this.getApi());
        token.getEnv().setAttribute("dataprovider:nsPrefix", nsPrefix);
        token.getEnv().setAttribute("dataprovider:interface:baseUrl", interfaceURL);
        token.getFullEnv().setAttribute("dataprovider:id", dsId);
        token.getFullEnv().setAttribute("dataprovider:originalid", dsId);
        token.getFullEnv().setAttribute("dataprovider:name", this.getProviderName());
        token.getFullEnv().setAttribute("dataprovider:interface", this.getApi());
        token.getFullEnv().setAttribute("dataprovider:nsPrefix", nsPrefix);
        token.getFullEnv().setAttribute("dataprovider:interface:baseUrl", interfaceURL);
        token.getProcess().getEnv().setAttribute("dataprovider:id", dsId);
        token.getProcess().getEnv().setAttribute("dataprovider:originalid", dsId);
        token.getProcess().getEnv().setAttribute("dataprovider:name", this.getProviderName());
        token.getProcess().getEnv().setAttribute("dataprovider:interface", this.getApi());
        token.getProcess().getEnv().setAttribute("dataprovider:nsPrefix", nsPrefix);
        token.getProcess().getEnv().setAttribute("dataprovider:interface:baseUrl", interfaceURL);
        return Arc.DEFAULT_ARC;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }
}

