<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:validator="http://eu.dnetlib/validator"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/" exclude-result-prefixes="xs" version="2.0">

	<xsl:output method="xml" indent="yes" />
	
    <xsl:template match="/">
        <oai:record xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:dri="http://www.driver-repository.eu/namespace/dri"
            xmlns:prov="http://www.openarchives.org/OAI/2.0/provenance"
            xmlns:oai="http://www.openarchives.org/OAI/2.0/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
            <oai:header>
                <xsl:apply-templates select="//*[./local-name()='header']/*"/>
                <xsl:apply-templates select="//validator:result"/>
            </oai:header>
            <xsl:apply-templates select="//*[./local-name()='metadata']"/>
            <xsl:apply-templates select="//*[./local-name()='about']"/>
        </oai:record>

    </xsl:template>

    <xsl:template match="validator:result">
        <validator:result score="{@score}" status="{@status}">
            <xsl:apply-templates select="./validator:failedRules"/>
        </validator:result>
    </xsl:template>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
