<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Retrieve information about current Content Provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="selectStoreToFetch"/>
	</ARCS>
</NODE>
<NODE name="selectStoreToFetch" type="Selection">
	<DESCRIPTION>Which records do you want to transform?</DESCRIPTION>
	<PARAMETERS>
		<PARAM function="validValues(['VALIDATED_RECORDS', 'NATIVE_RECORDS'])" managedBy="user" name="selection" required="true" type="string">VALIDATED_RECORDS</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC name="VALIDATED_RECORDS" to="fetchValidatedRecords" />
		<ARC name="NATIVE_RECORDS" to="fetchNativeRecords" />
	</ARCS>
</NODE>
<NODE name="fetchNativeRecords" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from native MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("coll_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("coll_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">epr_for_transformator</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="transformRecords"/>
	</ARCS>
</NODE>
<NODE name="fetchValidatedRecords" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from validated MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("val_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("coll_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">validated_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="prepareValidatedRecords"/>
	</ARCS>
</NODE>
<NODE name="prepareValidatedRecords" type="ApplyXslt">
	<DESCRIPTION>Prepare validated records for transformation</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">validated_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">epr_for_transformator</PARAM>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="user">/eu/dnetlib/msro/workflows/repo/validation/patchValidationHeader.xsl</PARAM></PARAMETERS>
	<ARCS>
		<ARC to="transformRecords"/>
	</ARCS>
</NODE>
<NODE name="transformRecords" type="Transform">
	<DESCRIPTION>Transform records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">epr_for_transformator</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">transformed_epr</PARAM>
		<PARAM required="true" type="string" name="ruleId" managedBy="user" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')" category="TRANSFORMATION_RULE_ID"  />
	</PARAMETERS>
	<ARCS>
		<ARC to="storeRecords"/>
	</ARCS>
</NODE>

<NODE name="storeRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store records into mdstore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">transformed_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="MDStoreToApiExtraField">
	<DESCRIPTION>Update datasource API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_aggregation_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_aggregation_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>