/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.configuration.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import eu.dnetlib.uoamonitorservice.configuration.properties.MongoConfig;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"eu.dnetlib.irishmonitorservice.dao"}, mongoTemplateRef="mongoIrishTemplate")
public class IrishMongoConnection {
    private final MongoConfig mongoConfig;

    @Autowired
    public IrishMongoConnection(MongoConfig mongoConfig) {
        this.mongoConfig = mongoConfig;
    }

    @Bean(name={"mongoIrishTemplate"})
    public MongoTemplate getMongoTemplate() {
        return new MongoTemplate(this.getMongoClient(), this.mongoConfig.getDatabase());
    }

    private MongoClient getMongoClient() {
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyToClusterSettings(b -> b.hosts(Collections.singletonList(new ServerAddress(this.mongoConfig.getHost(), this.mongoConfig.getPort()))));
        if (this.mongoConfig.getUsername() != null && this.mongoConfig.getPassword() != null) {
            MongoCredential credential = MongoCredential.createCredential((String)this.mongoConfig.getUsername(), (String)this.mongoConfig.getDatabase(), (char[])this.mongoConfig.getPassword().toCharArray());
            builder.credential(credential);
        }
        return MongoClients.create((MongoClientSettings)builder.build());
    }
}

