/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.controllers;

import eu.dnetlib.irishmonitorservice.dao.UserProfileDAO;
import eu.dnetlib.irishmonitorservice.entities.UserProfile;
import eu.dnetlib.uoaadmintoolslibrary.utils.RolesUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
@PreAuthorize(value="isAuthenticated()")
public class UserProfileController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final RolesUtils rolesUtils;
    private final UserProfileDAO dao;

    @Autowired
    public UserProfileController(RolesUtils rolesUtils, UserProfileDAO dao) {
        this.rolesUtils = rolesUtils;
        this.dao = dao;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<UserProfile> saveUserProfile(@RequestBody UserProfile userProfile) {
        userProfile.setAaiId(this.rolesUtils.getAaiId());
        if (this.dao.findByAaiId(userProfile.getAaiId()).isPresent()) {
            userProfile.setId(((UserProfile)this.dao.findByAaiId(userProfile.getAaiId()).get()).getId());
        }
        return ResponseEntity.ok((Object)((UserProfile)this.dao.save((Object)userProfile)));
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseEntity<UserProfile> getUserProfile() {
        return ResponseEntity.ok((Object)((UserProfile)this.dao.findByAaiId(this.rolesUtils.getAaiId()).orElseThrow(() -> new NotFoundException("No user profile found for: " + this.rolesUtils.getAaiId()))));
    }
}

