/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.services;

import eu.dnetlib.irishmonitorservice.configuration.mongo.IrishMongoConnection;
import eu.dnetlib.irishmonitorservice.configuration.properties.Properties;
import eu.dnetlib.uoamonitorservice.configuration.GlobalVars;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class DeployService {
    private final IrishMongoConnection mongoConnection;
    private final Properties properties;
    private final GlobalVars globalVars;

    @Autowired
    public DeployService(IrishMongoConnection mongoConnection, Properties properties, GlobalVars globalVars) {
        this.mongoConnection = mongoConnection;
        this.properties = properties;
        this.globalVars = globalVars;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        MongoTemplate mt = this.mongoConnection.getMongoTemplate();
        Document ping = new Document("ping", (Object)1);
        try {
            Document answer = mt.executeCommand(ping);
            response.put("Mongo try: error", String.valueOf(answer.getDouble((Object)"ok") == 1.0));
        }
        catch (Exception e) {
            response.put("Mongo catch: error", e.getMessage());
        }
        response.put("stats-tool.host", this.properties.getHost());
        response.put("Date of deploy", GlobalVars.date.toString());
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

