/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.services;

import eu.dnetlib.irishmonitorservice.configuration.properties.Indicators;
import eu.dnetlib.irishmonitorservice.configuration.properties.Properties;
import eu.dnetlib.irishmonitorservice.entities.Data;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class StatsToolService {
    private final Logger logger = LogManager.getLogger(StatsToolService.class);
    private final Properties properties;
    private final RestTemplate restTemplate;

    @Autowired
    public StatsToolService(Properties properties, RestTemplate restTemplate) {
        this.properties = properties;
        this.restTemplate = restTemplate;
    }

    @Cacheable(value={"funder"})
    public List<List<List<String>>> getFunders() {
        return this.getData(this.properties.getRfo());
    }

    @Cacheable(value={"organization"})
    public List<List<List<String>>> getOrganizations() {
        return this.getData(this.properties.getRpo());
    }

    @Cacheable(value={"datasource"})
    public List<List<List<String>>> getDataSources() {
        return this.getData(this.properties.getRepository());
    }

    public List<List<List<String>>> getData(Indicators indicators) {
        ArrayList<List<List<String>>> data = new ArrayList<List<List<String>>>();
        if (indicators != null) {
            data.add(this.getData(this.properties.getHost(), indicators.getPublications()));
            data.add(this.getData(this.properties.getHost(), indicators.getPublicationsPR()));
            data.add(this.getData(this.properties.getHost(), indicators.getPublicationsPROA()));
        }
        return data;
    }

    private List<List<String>> getData(String service, String json) {
        if (service == null || json == null) {
            return new ArrayList<List<String>>();
        }
        URI uri = UriComponentsBuilder.fromUriString((String)(service + URLDecoder.decode(json, StandardCharsets.UTF_8))).build().encode().toUri();
        try {
            ResponseEntity response = this.restTemplate.getForEntity(uri, Data.class);
            if (response.getStatusCode() == HttpStatus.OK) {
                return Objects.requireNonNull((Data)response.getBody()).getData();
            }
            return new ArrayList<List<String>>();
        }
        catch (RestClientException e) {
            return new ArrayList<List<String>>();
        }
    }
}

