/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.services;

import eu.dnetlib.irishmonitorservice.entities.SortBy;
import eu.dnetlib.irishmonitorservice.entities.StakeholderExtended;
import eu.dnetlib.irishmonitorservice.services.CacheService;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StakeholderExtendedService {
    private final StakeholderService service;
    private final CacheService cacheService;

    @Autowired
    public StakeholderExtendedService(StakeholderService service, CacheService cacheService) {
        this.service = service;
        this.cacheService = cacheService;
    }

    public StakeholderExtended getStakeholderExtended(String stakeholderId) throws UnsupportedEncodingException {
        Stakeholder stakeholder = this.service.findByPath(stakeholderId);
        List results = this.cacheService.getResponse(stakeholder.getType());
        if (results != null) {
            return new StakeholderExtended(stakeholder, this.getNumber(results, 0, stakeholder.getIndex_id()), this.getNumber(results, 1, stakeholder.getIndex_id()), this.getNumber(results, 2, stakeholder.getIndex_id()));
        }
        return new StakeholderExtended(stakeholder, "0", "0", "0");
    }

    public List<StakeholderExtended> getVisibleStakeholdersExtended(String type) throws UnsupportedEncodingException {
        List stakeholders = this.service.getVisibleStakeholders(type, null);
        List results = this.cacheService.getResponse(type);
        if (results != null) {
            return stakeholders.stream().map(stakeholder -> new StakeholderExtended(stakeholder, this.getNumber(results, 0, stakeholder.getIndex_id()), this.getNumber(results, 1, stakeholder.getIndex_id()), this.getNumber(results, 2, stakeholder.getIndex_id()))).collect(Collectors.toList());
        }
        return stakeholders.stream().map(stakeholder -> new StakeholderExtended(stakeholder, "0", "0", "0")).collect(Collectors.toList());
    }

    public String getNumber(List<List<List<String>>> results, int index, String id) {
        if (results != null && index < results.size()) {
            return results.get(index).stream().filter(list -> ((String)list.get(1)).equals(id)).findFirst().orElse(Collections.singletonList("0")).get(0);
        }
        return "0";
    }

    public List<StakeholderExtended> sortBy(List<StakeholderExtended> stakeholders, SortBy sort) {
        stakeholders.sort(Comparator.comparingInt(StakeholderExtended::getPublications).reversed());
        if (sort == SortBy.OPEN_ACCESS) {
            stakeholders.sort(Comparator.comparingDouble(a -> a.getOpenAccess().doubleValue()).reversed());
        }
        return stakeholders;
    }

    public void calculate() {
        this.cacheService.clearCache();
    }
}

