/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobcore.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import eu.dnetlib.jobcore.mongo.Mongo;
import java.util.Collections;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

public abstract class MongoConnection {
    protected Mongo mongo;

    protected MongoDatabaseFactory mongoDatabaseFactory(MongoClient mongoClient) {
        return new SimpleMongoClientDatabaseFactory(mongoClient, this.mongo.getDatabase());
    }

    protected MappingMongoConverter mappingMongoConverter(MongoDatabaseFactory factory, MongoMappingContext context) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        return new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
    }

    protected MongoTemplate getMongoTemplate(MongoClient mongoClient) {
        return new MongoTemplate(mongoClient, this.mongo.getDatabase());
    }

    protected MongoClient getMongoClient() {
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyToClusterSettings(b -> b.hosts(Collections.singletonList(new ServerAddress(this.mongo.getHost(), this.mongo.getPort()))));
        if (this.mongo.getUsername() != null && this.mongo.getPassword() != null) {
            MongoCredential credential = MongoCredential.createCredential((String)this.mongo.getUsername(), (String)this.mongo.getDatabase(), (char[])this.mongo.getPassword().toCharArray());
            builder.credential(credential);
        }
        return MongoClients.create((MongoClientSettings)builder.build());
    }
}

